/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.deserializers;

import java.util.function.Function;
import org.opensaml.core.xml.XMLObject;
import uk.gov.ida.saml.deserializers.OpenSamlXMLObjectUnmarshaller;
import uk.gov.ida.saml.deserializers.validators.Base64StringDecoder;
import uk.gov.ida.saml.deserializers.validators.NotNullSamlStringValidator;
import uk.gov.ida.saml.deserializers.validators.SizeValidator;

public class StringToOpenSamlObjectTransformer<TOutput extends XMLObject>
implements Function<String, TOutput> {
    private final NotNullSamlStringValidator notNullSamlStringValidator;
    private final Base64StringDecoder base64StringDecoder;
    private final SizeValidator sizeValidator;
    private final OpenSamlXMLObjectUnmarshaller<TOutput> openSamlXMLObjectUnmarshaller;

    public StringToOpenSamlObjectTransformer(NotNullSamlStringValidator notNullSamlStringValidator, Base64StringDecoder base64StringDecoder, SizeValidator sizeValidator, OpenSamlXMLObjectUnmarshaller<TOutput> openSamlXMLObjectUnmarshaller) {
        this.notNullSamlStringValidator = notNullSamlStringValidator;
        this.base64StringDecoder = base64StringDecoder;
        this.sizeValidator = sizeValidator;
        this.openSamlXMLObjectUnmarshaller = openSamlXMLObjectUnmarshaller;
    }

    @Override
    public TOutput apply(String input) {
        this.notNullSamlStringValidator.validate(input);
        String decodedInput = this.base64StringDecoder.decode(input);
        this.sizeValidator.validate(decodedInput);
        return this.openSamlXMLObjectUnmarshaller.fromString(decodedInput);
    }
}

