/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.deserializers;

import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.core.validation.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.deserializers.parser.SamlObjectParser;

public class OpenSamlXMLObjectUnmarshaller<TOutput extends XMLObject> {
    private final SamlObjectParser samlObjectParser;

    public OpenSamlXMLObjectUnmarshaller(SamlObjectParser samlObjectParser) {
        this.samlObjectParser = samlObjectParser;
    }

    public TOutput fromString(String input) {
        try {
            return (TOutput)this.samlObjectParser.getSamlObject(input);
        }
        catch (XMLParserException | UnmarshallingException e) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.unableToDeserializeStringToOpenSaml(input);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), (Exception)e, failure.getLogLevel());
        }
    }
}

