/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers;

import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import uk.gov.ida.saml.core.domain.IdentityProviderAuthnStatement;
import uk.gov.ida.saml.core.domain.IpAddress;
import uk.gov.ida.saml.core.extensions.IPAddress;
import uk.gov.ida.saml.core.transformers.AuthnContextFactory;

public class IdentityProviderAuthnStatementUnmarshaller {
    private final AuthnContextFactory authnContextFactory;

    public IdentityProviderAuthnStatementUnmarshaller(AuthnContextFactory authnContextFactory) {
        this.authnContextFactory = authnContextFactory;
    }

    public IdentityProviderAuthnStatement fromAssertion(Assertion assertion) {
        AuthnStatement authnStatement = (AuthnStatement)assertion.getAuthnStatements().get(0);
        String levelOfAssurance = authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef();
        IpAddress ipAddress = null;
        block0: for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                if (!attribute.getName().equals("TXN_IPaddress")) continue;
                ipAddress = new IpAddress(((IPAddress)attribute.getAttributeValues().get(0)).getValue());
                continue block0;
            }
        }
        return IdentityProviderAuthnStatement.createIdentityProviderAuthnStatement(this.authnContextFactory.authnContextForLevelOfAssurance(levelOfAssurance), ipAddress);
    }
}

