/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import org.joda.time.LocalDate;
import uk.gov.ida.saml.core.domain.Address;
import uk.gov.ida.saml.core.domain.Gender;
import uk.gov.ida.saml.core.domain.SimpleMdsValue;
import uk.gov.ida.saml.core.domain.TransliterableMdsValue;

public class MatchingDataset {
    private final List<TransliterableMdsValue> firstNames;
    private final List<SimpleMdsValue<String>> middleNames;
    private final List<TransliterableMdsValue> surnames;
    private final Optional<SimpleMdsValue<Gender>> gender;
    private final List<SimpleMdsValue<LocalDate>> dateOfBirths;
    private final List<Address> currentAddresses;
    private final List<Address> previousAddresses;
    private final String personalId;

    public MatchingDataset(List<TransliterableMdsValue> firstNames, List<SimpleMdsValue<String>> middleNames, List<TransliterableMdsValue> surnames, Optional<SimpleMdsValue<Gender>> gender, List<SimpleMdsValue<LocalDate>> dateOfBirths, List<Address> currentAddresses, List<Address> previousAddresses, String personalId) {
        this.firstNames = firstNames;
        this.middleNames = middleNames;
        this.surnames = surnames;
        this.gender = gender;
        this.dateOfBirths = dateOfBirths;
        this.currentAddresses = currentAddresses;
        this.previousAddresses = previousAddresses;
        this.personalId = personalId;
    }

    public List<TransliterableMdsValue> getFirstNames() {
        return this.firstNames;
    }

    public List<SimpleMdsValue<String>> getMiddleNames() {
        return this.middleNames;
    }

    public List<TransliterableMdsValue> getSurnames() {
        return this.surnames;
    }

    public Optional<SimpleMdsValue<Gender>> getGender() {
        return this.gender;
    }

    public List<SimpleMdsValue<LocalDate>> getDateOfBirths() {
        return this.dateOfBirths;
    }

    public List<Address> getCurrentAddresses() {
        return this.currentAddresses;
    }

    public List<Address> getPreviousAddresses() {
        return this.previousAddresses;
    }

    public List<Address> getAddresses() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.currentAddresses, this.previousAddresses));
    }

    public String getPersonalId() {
        return this.personalId;
    }
}

