/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.jerseyclient;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import uk.gov.ida.jerseyclient.ErrorHandlingClient;
import uk.gov.ida.jerseyclient.JsonResponseProcessor;

public class JsonClient {
    private final JsonResponseProcessor responseProcessor;
    private final ErrorHandlingClient errorHandlingClient;

    @Inject
    public JsonClient(ErrorHandlingClient errorHandlingClient, JsonResponseProcessor responseProcessor) {
        this.errorHandlingClient = errorHandlingClient;
        this.responseProcessor = responseProcessor;
    }

    public <T> T post(Object postBody, URI uri, Class<T> clazz) {
        return this.responseProcessor.getJsonEntity(uri, null, clazz, this.errorHandlingClient.post(uri, postBody));
    }

    public <T> T post(Object postBody, URI uri, Class<T> clazz, Map<String, String> headers) {
        return this.responseProcessor.getJsonEntity(uri, null, clazz, this.errorHandlingClient.post(uri, headers, postBody));
    }

    public void post(Object postBody, URI uri) {
        this.responseProcessor.getJsonEntity(uri, null, null, this.errorHandlingClient.post(uri, postBody));
    }

    public <T> T get(URI uri, Class<T> clazz) {
        return this.responseProcessor.getJsonEntity(uri, null, clazz, this.errorHandlingClient.get(uri));
    }

    public <T> T get(URI uri, Class<T> clazz, Map<String, String> headers) {
        return this.responseProcessor.getJsonEntity(uri, null, clazz, this.errorHandlingClient.get(uri, headers));
    }

    public <T> T get(URI uri, Class<T> clazz, List<Cookie> cookies, Map<String, String> headers) {
        return this.responseProcessor.getJsonEntity(uri, null, clazz, this.errorHandlingClient.get(uri, cookies, headers));
    }

    public <T> T get(URI uri, GenericType<T> genericType) {
        return this.responseProcessor.getJsonEntity(uri, genericType, null, this.errorHandlingClient.get(uri));
    }
}

