/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.UUID;
import uk.gov.ida.common.ErrorStatusDto;
import uk.gov.ida.common.ExceptionType;

public final class ApplicationException
extends RuntimeException {
    public static final String ERROR_MESSAGE_FORMAT = "{0}\nClient Message: {1}";
    private final UUID errorId;
    private final ExceptionType exceptionType;
    private final boolean audited;
    private final Optional<URI> uri;
    private final Optional<String> clientMessage;

    private ApplicationException(ExceptionType exceptionType, boolean audited, UUID errorId) {
        this(exceptionType, audited, errorId, null, Optional.empty(), Optional.empty());
    }

    private ApplicationException(ExceptionType exceptionType, boolean audited, UUID errorId, Throwable cause) {
        this(exceptionType, audited, errorId, cause, Optional.empty(), Optional.empty());
    }

    private ApplicationException(ExceptionType exceptionType, boolean audited, UUID errorId, Throwable cause, Optional<URI> uri, Optional<String> clientMessage) {
        super(MessageFormat.format("Exception of type [{0}] {1}", new Object[]{exceptionType, ApplicationException.getUriErrorMessage(uri)}), cause);
        this.exceptionType = exceptionType;
        this.errorId = errorId;
        this.audited = audited;
        this.uri = uri;
        this.clientMessage = clientMessage;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.clientMessage.isPresent()) {
            return MessageFormat.format(ERROR_MESSAGE_FORMAT, message, this.clientMessage.get());
        }
        return message;
    }

    private ApplicationException(ErrorStatusDto errorStatus, URI uri) {
        this(errorStatus.getExceptionType(), errorStatus.isAudited(), errorStatus.getErrorId(), null, Optional.ofNullable(uri), Optional.ofNullable(errorStatus.getClientMessage()));
    }

    public static ApplicationException createUnauditedException(ExceptionType exceptionType, UUID errorId) {
        return new ApplicationException(exceptionType, false, errorId);
    }

    public static ApplicationException createUnauditedException(ExceptionType exceptionType, String message, Throwable cause) {
        return new ApplicationException(exceptionType, false, UUID.randomUUID(), cause, Optional.empty(), Optional.of(message));
    }

    public static ApplicationException createUnauditedException(ExceptionType exceptionType, UUID errorId, Throwable cause, URI uri) {
        return new ApplicationException(exceptionType, false, errorId, cause, Optional.ofNullable(uri), Optional.empty());
    }

    public static ApplicationException createUnauditedException(ExceptionType exceptionType, UUID errorId, Throwable cause) {
        return new ApplicationException(exceptionType, false, errorId, cause);
    }

    public static ApplicationException createAuditedException(ExceptionType exceptionType, UUID errorId) {
        return new ApplicationException(exceptionType, true, errorId);
    }

    public static ApplicationException createUnauditedException(ExceptionType exceptionType, UUID errorId, URI uri) {
        return new ApplicationException(exceptionType, false, errorId, null, Optional.ofNullable(uri), Optional.empty());
    }

    public static ApplicationException createExceptionFromErrorStatusDto(ErrorStatusDto errorStatusDto, URI uri) {
        return new ApplicationException(errorStatusDto, uri);
    }

    private static String getUriErrorMessage(Optional<URI> uri) {
        if (uri.isPresent()) {
            return MessageFormat.format("whilst contacting uri: {0}", uri.get());
        }
        return "";
    }

    public UUID getErrorId() {
        return this.errorId;
    }

    public ExceptionType getExceptionType() {
        return this.exceptionType;
    }

    public boolean isAudited() {
        return this.audited;
    }

    public Optional<URI> getUri() {
        return this.uri;
    }

    public boolean requiresAuditing() {
        return this.exceptionType != ExceptionType.NETWORK_ERROR;
    }
}

