/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.jersey.oauth2.authentication.tokenmanager;

import io.dropwizard.client.JerseyClientBuilder;
import io.dropwizard.setup.Environment;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import uk.gov.jersey.oauth2.authentication.configuration.ClientCredentials;
import uk.gov.jersey.oauth2.authentication.configuration.OAuth2Configuration;
import uk.gov.jersey.oauth2.authentication.entity.AccessTokenResponse;
import uk.gov.jersey.oauth2.authentication.entity.OAuth2ErrorResponse;
import uk.gov.jersey.oauth2.authentication.exception.AccessTokenRequestException;
import uk.gov.jersey.oauth2.authentication.tokencache.TokenCache;

public class AccessTokenManager {
    private final TokenCache tokenCache;
    private final OAuth2Configuration oAuth2Config;
    private final Client client;

    private static Client getAuthorizationClient(OAuth2Configuration oauth2Config, Environment environment) {
        Client client = new JerseyClientBuilder(environment).using(oauth2Config.getJerseyClient()).build(oauth2Config.getJerseyClientName());
        if (!oauth2Config.sendClientCredentialsInBody()) {
            ClientCredentials credentials = oauth2Config.getClientCredentials();
            HttpAuthenticationFeature authFeature = HttpAuthenticationFeature.basic((String)credentials.getClientId(), (String)credentials.getClientSecret());
            client.register((Object)authFeature);
        }
        return client;
    }

    public AccessTokenManager(TokenCache tokenCache, OAuth2Configuration oAuth2Config, Client client) {
        this.tokenCache = tokenCache;
        this.client = client;
        this.oAuth2Config = oAuth2Config;
    }

    public AccessTokenManager(TokenCache tokenCache, OAuth2Configuration oAuth2Config, Environment environment) {
        this(tokenCache, oAuth2Config, AccessTokenManager.getAuthorizationClient(oAuth2Config, environment));
    }

    public Client getClient() {
        return this.client;
    }

    public String getAccessToken() {
        return this.tokenCache.getAccessToken().orElseGet(() -> {
            AccessTokenResponse accessTokenResponse = this.requestAccessToken();
            Duration expiresIn = Duration.of(accessTokenResponse.getExpiresIn(), ChronoUnit.SECONDS).minus(this.oAuth2Config.getTokenValiditySkew());
            this.tokenCache.updateToken(accessTokenResponse.getAccessToken(), expiresIn);
            return accessTokenResponse.getAccessToken();
        });
    }

    protected AccessTokenResponse requestAccessToken() {
        WebTarget target = this.client.target(this.oAuth2Config.getAuthorisationServerEndpoint());
        Invocation.Builder requestBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        requestBuilder.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        Form form = new Form();
        if (this.oAuth2Config.sendClientCredentialsInBody()) {
            form.param(this.oAuth2Config.getClientIdBodyParameter(), this.oAuth2Config.getClientCredentials().getClientId());
            form.param(this.oAuth2Config.getClientSecretBodyParameter(), this.oAuth2Config.getClientCredentials().getClientSecret());
        }
        form.param("grant_type", "client_credentials");
        this.oAuth2Config.getAdditionalAccessTokenRequestParameters().forEach((arg_0, arg_1) -> ((Form)form).param(arg_0, arg_1));
        Response response = requestBuilder.build("POST", Entity.form((Form)form)).invoke();
        if (response.getStatus() < 300) {
            return (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
        }
        try {
            OAuth2ErrorResponse error = (OAuth2ErrorResponse)response.readEntity(OAuth2ErrorResponse.class);
            throw new AccessTokenRequestException(MessageFormat.format("{0}: {1}", error.getError(), error.getErrorDescription()));
        }
        catch (ProcessingException e) {
            throw new AccessTokenRequestException(MessageFormat.format("Access token request failed with status {0}", response.getStatus()));
        }
    }
}

