/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.jersey.oauth2.authentication.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.client.JerseyClientConfiguration;
import io.dropwizard.util.Duration;
import java.net.URI;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import uk.gov.jersey.oauth2.authentication.configuration.ClientCredentials;

public class OAuth2Configuration {
    @JsonProperty
    @Valid
    private URI authorisationServerEndpoint;
    @JsonProperty
    @NotNull
    private ClientCredentials clientCredentials;
    @JsonProperty
    private JerseyClientConfiguration jerseyClient = new JerseyClientConfiguration();
    @JsonProperty
    private String jerseyClientName = "oauth2-authorization-client";
    @JsonProperty
    private boolean sendClientCredentialsInBody = false;
    @JsonProperty
    private String clientIdBodyParameter = "clientId";
    @JsonProperty
    private String clientSecretBodyParameter = "secret";
    @JsonProperty
    private Map<String, String> additionalAccessTokenRequestParameters = Map.of();
    @JsonProperty
    private Duration tokenValiditySkew = Duration.seconds((long)0L);

    public URI getAuthorisationServerEndpoint() {
        return this.authorisationServerEndpoint;
    }

    public ClientCredentials getClientCredentials() {
        return this.clientCredentials;
    }

    public JerseyClientConfiguration getJerseyClient() {
        return this.jerseyClient;
    }

    public String getJerseyClientName() {
        return this.jerseyClientName;
    }

    public boolean sendClientCredentialsInBody() {
        return this.sendClientCredentialsInBody;
    }

    public String getClientIdBodyParameter() {
        return this.clientIdBodyParameter;
    }

    public String getClientSecretBodyParameter() {
        return this.clientSecretBodyParameter;
    }

    public Map<String, String> getAdditionalAccessTokenRequestParameters() {
        return this.additionalAccessTokenRequestParameters;
    }

    public java.time.Duration getTokenValiditySkew() {
        return java.time.Duration.of(this.tokenValiditySkew.toMilliseconds(), ChronoUnit.MILLIS);
    }

    public OAuth2Configuration setAuthorisationServerEndpoint(URI authorisationServerEndpoint) {
        this.authorisationServerEndpoint = authorisationServerEndpoint;
        return this;
    }

    public OAuth2Configuration setClientCredentials(ClientCredentials clientCredentials) {
        this.clientCredentials = clientCredentials;
        return this;
    }

    public OAuth2Configuration setJerseyClient(JerseyClientConfiguration jerseyClient) {
        this.jerseyClient = jerseyClient;
        return this;
    }

    public OAuth2Configuration setJerseyClientName(String jerseyClientName) {
        this.jerseyClientName = jerseyClientName;
        return this;
    }

    public OAuth2Configuration setSendClientCredentialsInBody(boolean sendClientCredentialsInBody) {
        this.sendClientCredentialsInBody = sendClientCredentialsInBody;
        return this;
    }

    public OAuth2Configuration setClientIdBodyParameter(String clientIdBodyParameter) {
        this.clientIdBodyParameter = clientIdBodyParameter;
        return this;
    }

    public OAuth2Configuration setClientSecretBodyParameter(String clientSecretBodyParameter) {
        this.clientSecretBodyParameter = clientSecretBodyParameter;
        return this;
    }

    public OAuth2Configuration setAdditionalAccessTokenRequestParameters(Map<String, String> additionalAccessTokenRequestParameters) {
        this.additionalAccessTokenRequestParameters = additionalAccessTokenRequestParameters;
        return this;
    }

    public OAuth2Configuration setTokenValiditySkew(Duration tokenValiditySkew) {
        this.tokenValiditySkew = tokenValiditySkew;
        return this;
    }
}

