/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.jersey.oauth2.authentication.filter;

import java.io.IOException;
import java.text.MessageFormat;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.jersey.oauth2.authentication.exception.AccessTokenRequestException;
import uk.gov.jersey.oauth2.authentication.tokenmanager.AccessTokenManager;

public class BearerTokenHeaderFilter
implements ClientRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(BearerTokenHeaderFilter.class);
    private static final String BEARER_TOKEN_FORMAT = "Bearer {0}";
    private final AccessTokenManager accessTokenManager;

    public BearerTokenHeaderFilter(AccessTokenManager accessTokenManager) {
        this.accessTokenManager = accessTokenManager;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (requestContext.getHeaders().containsKey((Object)"Authorization")) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Authorization header already exists on request").build());
        }
        try {
            requestContext.getHeaders().add((Object)"Authorization", (Object)MessageFormat.format(BEARER_TOKEN_FORMAT, this.accessTokenManager.getAccessToken()));
        }
        catch (AccessTokenRequestException e) {
            LOG.warn("Unable to get access token", (Throwable)e);
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Unable to get access token").build());
        }
    }
}

