/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.jersey.oauth2.authentication.feature;

import io.dropwizard.setup.Environment;
import java.time.Clock;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import uk.gov.jersey.oauth2.authentication.configuration.OAuth2Configuration;
import uk.gov.jersey.oauth2.authentication.filter.BearerTokenHeaderFilter;
import uk.gov.jersey.oauth2.authentication.tokencache.InMemoryTokenCache;
import uk.gov.jersey.oauth2.authentication.tokencache.TokenCache;
import uk.gov.jersey.oauth2.authentication.tokenmanager.AccessTokenManager;

public class OAuthClientCredentialsGrantAuthorizationFeature
implements Feature {
    private final AccessTokenManager accessTokenManager;

    public OAuthClientCredentialsGrantAuthorizationFeature(AccessTokenManager accessTokenManager) {
        this.accessTokenManager = accessTokenManager;
    }

    public OAuthClientCredentialsGrantAuthorizationFeature(OAuth2Configuration oAuth2Config, Client client) {
        this(new AccessTokenManager((TokenCache)new InMemoryTokenCache(Clock.systemDefaultZone()), oAuth2Config, client));
    }

    public OAuthClientCredentialsGrantAuthorizationFeature(TokenCache tokenCache, OAuth2Configuration oAuth2Config, Environment environment) {
        this(new AccessTokenManager(tokenCache, oAuth2Config, environment));
    }

    public OAuthClientCredentialsGrantAuthorizationFeature(OAuth2Configuration oAuth2Config, Environment environment) {
        this(new AccessTokenManager((TokenCache)new InMemoryTokenCache(Clock.systemDefaultZone()), oAuth2Config, environment));
    }

    public boolean configure(FeatureContext context) {
        context.register((Object)new BearerTokenHeaderFilter(this.accessTokenManager), 2000);
        return true;
    }

    public AccessTokenManager getAccessTokenManager() {
        return this.accessTokenManager;
    }
}

