/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.jersey.oauth2.authentication.tokencache;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import uk.gov.jersey.oauth2.authentication.tokencache.TokenCache;

public class InMemoryTokenCache
implements TokenCache {
    private volatile String accessToken;
    private volatile Instant expires;
    private final Clock clock;
    private final Object lock = new Object();

    public InMemoryTokenCache(Clock clock) {
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> getAccessToken() {
        Object object = this.lock;
        synchronized (object) {
            return this.accessToken == null || this.clock.instant().isAfter(this.expires) ? Optional.empty() : Optional.of(this.accessToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenCache updateToken(String accessToken, Duration expires) {
        Object object = this.lock;
        synchronized (object) {
            this.accessToken = accessToken;
            this.expires = this.clock.instant().plus(expires);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenCache clear() {
        Object object = this.lock;
        synchronized (object) {
            this.accessToken = null;
        }
        return this;
    }
}

