/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata.transformers;

import java.util.List;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyName;
import org.slf4j.event.Level;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;

public class KeyDescriptorFinder {
    public KeyDescriptor find(List<KeyDescriptor> keyDescriptors, UsageType usageType, String entityId) {
        return keyDescriptors.stream().filter(keyDescriptor -> keyDescriptor.getUse().equals((Object)usageType)).filter(keyDescriptor -> keyDescriptor.getKeyInfo().getKeyNames().isEmpty() || entityId == null || ((KeyName)keyDescriptor.getKeyInfo().getKeyNames().get(0)).getValue().equals(entityId)).findFirst().orElseThrow(() -> this.throwError(usageType, entityId));
    }

    private SamlTransformationErrorException throwError(UsageType usageType, String entityId) {
        SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingKey((String)usageType.toString(), (String)entityId);
        return new SamlTransformationErrorException(failure.getErrorMessage(), Level.ERROR);
    }
}

