/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.response.matchingservice;

import com.google.common.base.Strings;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.xmlsec.signature.Signature;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.hub.exception.SamlValidationException;
import uk.gov.ida.saml.hub.validators.response.common.IssuerValidator;
import uk.gov.ida.saml.hub.validators.response.common.RequestIdValidator;
import uk.gov.ida.saml.security.validators.signature.SamlSignatureUtil;

public class HealthCheckResponseFromMatchingServiceValidator {
    public void validate(Response response) {
        IssuerValidator.validate(response);
        RequestIdValidator.validate(response);
        this.validateResponse(response);
    }

    private void validateResponse(Response response) {
        if (Strings.isNullOrEmpty((String)response.getID())) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingId());
        }
        Signature signature = response.getSignature();
        if (signature == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingSignature());
        }
        if (!SamlSignatureUtil.isSignaturePresent((Signature)signature)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.signatureNotSigned());
        }
        this.validateStatusAndSubStatus(response);
    }

    protected void validateStatusAndSubStatus(Response response) {
        StatusCode statusCode = response.getStatus().getStatusCode();
        if ("urn:oasis:names:tc:SAML:2.0:status:Requester".equals(statusCode.getValue())) {
            return;
        }
        if (statusCode.getStatusCode() == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingSubStatus());
        }
        String statusCodeValue = statusCode.getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCodeValue)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.invalidStatusCode((String)statusCodeValue));
        }
        String subStatusCodeValue = statusCode.getStatusCode().getValue();
        if (!"urn:uk:gov:cabinet-office:tc:saml:statuscode:healthy".equals(subStatusCodeValue)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.invalidSubStatusCode((String)subStatusCodeValue, (String)"urn:oasis:names:tc:SAML:2.0:status:Success"));
        }
    }
}

