/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.response.idp.components;

import com.google.common.base.Strings;
import java.util.List;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.xmlsec.signature.Signature;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.hub.exception.SamlValidationException;
import uk.gov.ida.saml.hub.transformers.inbound.SamlStatusToAuthenticationStatusCodeMapper;
import uk.gov.ida.saml.hub.validators.response.common.IssuerValidator;
import uk.gov.ida.saml.hub.validators.response.common.RequestIdValidator;
import uk.gov.ida.saml.security.validators.signature.SamlSignatureUtil;

public class EncryptedResponseFromIdpValidator<T extends Enum<T>> {
    private static final int SUB_STATUS_CODE_LIMIT = 1;
    private SamlStatusToAuthenticationStatusCodeMapper<T> statusCodeMapper;

    public EncryptedResponseFromIdpValidator(SamlStatusToAuthenticationStatusCodeMapper<T> statusCodeMapper) {
        this.statusCodeMapper = statusCodeMapper;
    }

    protected void validateAssertionPresence(Response response) {
        if (!response.getAssertions().isEmpty()) {
            throw new SamlValidationException(SamlTransformationErrorFactory.unencryptedAssertion());
        }
        boolean responseWasSuccessful = response.getStatus().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success");
        List encryptedAssertions = response.getEncryptedAssertions();
        if (responseWasSuccessful && encryptedAssertions.isEmpty()) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingSuccessUnEncryptedAssertions());
        }
        if (!responseWasSuccessful && !encryptedAssertions.isEmpty()) {
            throw new SamlValidationException(SamlTransformationErrorFactory.nonSuccessHasUnEncryptedAssertions());
        }
        if (responseWasSuccessful && encryptedAssertions.size() != 2) {
            throw new SamlValidationException(SamlTransformationErrorFactory.unexpectedNumberOfAssertions((int)2, (int)encryptedAssertions.size()));
        }
    }

    public void validate(Response response) {
        IssuerValidator.validate(response);
        RequestIdValidator.validate(response);
        this.validateResponse(response);
    }

    private void validateResponse(Response response) {
        if (Strings.isNullOrEmpty((String)response.getID())) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingId());
        }
        if (response.getIssueInstant() == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingIssueInstant((String)response.getID()));
        }
        Signature signature = response.getSignature();
        if (signature == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingSignature());
        }
        if (!SamlSignatureUtil.isSignaturePresent((Signature)signature)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.signatureNotSigned());
        }
        this.validateStatus(response.getStatus());
        this.validateAssertionPresence(response);
    }

    private void validateStatus(Status status) {
        this.validateStatusCode(status.getStatusCode(), 0);
        if (this.statusCodeMapper.map(status).isEmpty()) {
            this.fail(status);
        }
    }

    private void fail(Status status) {
        StatusCode statusCode = status.getStatusCode();
        StatusCode subStatusCode = statusCode.getStatusCode();
        if (subStatusCode == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.invalidStatusCode((String)statusCode.getValue()));
        }
        SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.invalidSubStatusCode((String)subStatusCode.getValue(), (String)statusCode.getValue());
        throw new SamlValidationException(failure);
    }

    private void validateStatusCode(StatusCode statusCode, int subStatusCount) {
        if (subStatusCount > 1) {
            throw new SamlValidationException(SamlTransformationErrorFactory.nestedSubStatusCodesBreached((int)1));
        }
        StatusCode subStatus = statusCode.getStatusCode();
        if (subStatus != null) {
            this.validateStatusCode(subStatus, subStatusCount + 1);
        }
    }
}

