/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import com.google.inject.Inject;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Scoping;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.AuthnContext;
import uk.gov.ida.saml.hub.domain.IdaAuthnRequestFromHub;
import uk.gov.ida.saml.hub.transformers.outbound.IdaAuthnRequestToAuthnRequestTransformer;

public class IdaAuthnRequestFromHubToAuthnRequestTransformer
extends IdaAuthnRequestToAuthnRequestTransformer<IdaAuthnRequestFromHub> {
    @Inject
    public IdaAuthnRequestFromHubToAuthnRequestTransformer(OpenSamlXmlObjectFactory samlObjectFactory) {
        super(samlObjectFactory);
    }

    @Override
    protected void supplementAuthnRequestWithDetails(IdaAuthnRequestFromHub originalRequestFromHub, AuthnRequest authnRequest) {
        Conditions conditions = this.getSamlObjectFactory().createConditions();
        conditions.setNotOnOrAfter(originalRequestFromHub.getSessionExpiryTimestamp());
        authnRequest.setConditions(conditions);
        Scoping scoping = this.getSamlObjectFactory().createScoping();
        scoping.setProxyCount(Integer.valueOf(0));
        authnRequest.setScoping(scoping);
        AuthnContextComparisonTypeEnumeration comparisonType = originalRequestFromHub.getComparisonType();
        RequestedAuthnContext requestedAuthnContext = this.getSamlObjectFactory().createRequestedAuthnContext(comparisonType);
        originalRequestFromHub.getLevelsOfAssurance().stream().map(AuthnContext::getUri).map(uri -> this.getSamlObjectFactory().createAuthnContextClassReference(uri)).forEach(ref -> requestedAuthnContext.getAuthnContextClassRefs().add(ref));
        NameIDPolicy nameIdPolicy = this.getSamlObjectFactory().createNameIdPolicy();
        nameIdPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        nameIdPolicy.setSPNameQualifier("https://hub.gov.uk");
        nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
        authnRequest.setNameIDPolicy(nameIdPolicy);
        authnRequest.setRequestedAuthnContext(requestedAuthnContext);
        if (originalRequestFromHub.getForceAuthentication().isPresent()) {
            authnRequest.setForceAuthn((Boolean)originalRequestFromHub.getForceAuthentication().get());
        }
    }
}

