/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.inbound;

import java.text.MessageFormat;
import java.util.Optional;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.w3c.dom.Node;
import uk.gov.ida.saml.core.domain.IdaStatus;
import uk.gov.ida.saml.hub.domain.AuthenticationStatusFactory;
import uk.gov.ida.saml.hub.transformers.inbound.SamlStatusToAuthenticationStatusCodeMapper;

public abstract class AuthenticationStatusUnmarshallerBase<T extends Enum, U extends IdaStatus> {
    private final SamlStatusToAuthenticationStatusCodeMapper<T> statusMapper;
    private final AuthenticationStatusFactory<T, U> statusFactory;

    public AuthenticationStatusUnmarshallerBase(SamlStatusToAuthenticationStatusCodeMapper<T> statusMapper, AuthenticationStatusFactory<T, U> authenticationStatusFactory) {
        this.statusMapper = statusMapper;
        this.statusFactory = authenticationStatusFactory;
    }

    public U fromSaml(Status samlStatus) {
        T status = this.getStatus(samlStatus);
        String message = this.getStatusMessage(samlStatus).orElse(null);
        return this.statusFactory.create(status, message);
    }

    private T getStatus(Status samlStatus) {
        return (T)((Enum)this.statusMapper.map(samlStatus).orElseThrow(() -> new IllegalStateException(MessageFormat.format("Could not map status to an IdaStatus: {0}", SerializeSupport.nodeToString((Node)samlStatus.getDOM())))));
    }

    private Optional<String> getStatusMessage(Status samlStatus) {
        StatusMessage statusMessage = samlStatus.getStatusMessage();
        return statusMessage != null ? Optional.of(statusMessage.getMessage()) : Optional.empty();
    }
}

