/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.validators.assertion;

import com.google.common.base.Strings;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.extensions.IPAddress;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;

public class IPAddressValidator {
    public void validate(Assertion assertion) {
        for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                if (!attribute.getName().equals("TXN_IPaddress")) continue;
                IPAddress ipAddressAttributeValue = (IPAddress)attribute.getAttributeValues().get(0);
                String addressValue = ipAddressAttributeValue.getValue();
                if (!Strings.isNullOrEmpty((String)addressValue)) {
                    return;
                }
                SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.emptyIPAddress((String)assertion.getID());
                throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
            }
        }
        SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingIPAddress((String)assertion.getID());
        throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
    }
}

