/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import com.google.inject.Inject;
import java.util.function.Function;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import uk.gov.ida.saml.core.transformers.outbound.decorators.SamlSignatureSigner;
import uk.gov.ida.saml.hub.transformers.outbound.SigningRequestAbstractTypeSignatureCreator;
import uk.gov.ida.saml.serializers.XmlObjectToBase64EncodedStringTransformer;

public class RequestAbstractTypeToStringTransformer<TInput extends RequestAbstractType>
implements Function<TInput, String> {
    private final SigningRequestAbstractTypeSignatureCreator<TInput> signatureCreator;
    private final SamlSignatureSigner<TInput> samlSignatureSigner;
    private final XmlObjectToBase64EncodedStringTransformer<TInput> xmlObjectToBase64EncodedStringTransformer;

    @Inject
    public RequestAbstractTypeToStringTransformer(SigningRequestAbstractTypeSignatureCreator<TInput> signatureCreator, SamlSignatureSigner<TInput> samlSignatureSigner, XmlObjectToBase64EncodedStringTransformer<TInput> xmlObjectToBase64EncodedStringTransformer) {
        this.signatureCreator = signatureCreator;
        this.samlSignatureSigner = samlSignatureSigner;
        this.xmlObjectToBase64EncodedStringTransformer = xmlObjectToBase64EncodedStringTransformer;
    }

    @Override
    public String apply(TInput input) {
        RequestAbstractType requestWithSignature = this.signatureCreator.addUnsignedSignatureTo(input);
        RequestAbstractType signedRequest = (RequestAbstractType)this.samlSignatureSigner.sign((SignableXMLObject)requestWithSignature);
        return (String)this.xmlObjectToBase64EncodedStringTransformer.apply((Object)signedRequest);
    }
}

