/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import java.util.Map;
import java.util.Optional;
import org.opensaml.saml.saml2.core.StatusDetail;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.DetailedStatusCode;
import uk.gov.ida.saml.core.extensions.StatusValue;
import uk.gov.ida.saml.core.transformers.outbound.IdaStatusMarshaller;
import uk.gov.ida.saml.hub.domain.IdpIdaStatus;

public class IdpIdaStatusMarshaller
extends IdaStatusMarshaller<IdpIdaStatus> {
    private static final Map<IdpIdaStatus, DetailedStatusCode> REST_TO_SAML_CODES = Map.of(IdpIdaStatus.success(), DetailedStatusCode.Success, IdpIdaStatus.noAuthenticationContext(), DetailedStatusCode.NoAuthenticationContext, IdpIdaStatus.authenticationFailed(), DetailedStatusCode.AuthenticationFailed, IdpIdaStatus.requesterError(), DetailedStatusCode.RequesterErrorFromIdp, IdpIdaStatus.authenticationCancelled(), DetailedStatusCode.NoAuthenticationContext, IdpIdaStatus.authenticationPending(), DetailedStatusCode.NoAuthenticationContext, IdpIdaStatus.upliftFailed(), DetailedStatusCode.NoAuthenticationContext);
    private static final Map<IdpIdaStatus, String> REST_TO_STATUS_DETAIL = Map.of(IdpIdaStatus.authenticationCancelled(), "authn-cancel", IdpIdaStatus.authenticationPending(), "loa-pending", IdpIdaStatus.upliftFailed(), "uplift-failed");

    public IdpIdaStatusMarshaller(OpenSamlXmlObjectFactory samlObjectFactory) {
        super(samlObjectFactory);
    }

    protected Optional<String> getStatusMessage(IdpIdaStatus originalStatus) {
        return originalStatus.getMessage();
    }

    protected Optional<StatusDetail> getStatusDetail(IdpIdaStatus originalStatus) {
        if (REST_TO_STATUS_DETAIL.containsKey(originalStatus)) {
            StatusDetail statusDetail = this.samlObjectFactory.createStatusDetail();
            StatusValue statusValue = this.samlObjectFactory.createStatusValue(REST_TO_STATUS_DETAIL.get(originalStatus));
            statusDetail.getUnknownXMLObjects().add(statusValue);
            return Optional.of(statusDetail);
        }
        return Optional.empty();
    }

    protected DetailedStatusCode getDetailedStatusCode(IdpIdaStatus originalStatus) {
        return REST_TO_SAML_CODES.get(originalStatus);
    }
}

