/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.validators.assertion;

import com.google.inject.Inject;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validators.assertion.DuplicateAssertionValidator;
import uk.gov.ida.saml.hub.exception.SamlValidationException;
import uk.gov.ida.saml.hub.validators.authnrequest.IdExpirationCache;

public class DuplicateAssertionValidatorImpl
implements DuplicateAssertionValidator {
    private final IdExpirationCache<String> idExpirationCache;

    @Inject
    public DuplicateAssertionValidatorImpl(IdExpirationCache<String> idExpirationCache) {
        this.idExpirationCache = idExpirationCache;
    }

    @Override
    public void validateAuthnStatementAssertion(Assertion assertion) {
        if (!this.valid(assertion)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.authnStatementAlreadyReceived((String)assertion.getID()));
        }
    }

    @Override
    public void validateMatchingDataSetAssertion(Assertion assertion, String responseIssuerId) {
        if (!this.valid(assertion)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.duplicateMatchingDataset((String)assertion.getID(), (String)responseIssuerId));
        }
    }

    private boolean valid(Assertion assertion) {
        if (this.isDuplicateNonExpired(assertion)) {
            return false;
        }
        DateTime expire = ((SubjectConfirmation)assertion.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData().getNotOnOrAfter();
        this.idExpirationCache.setExpiration(assertion.getID(), expire);
        return true;
    }

    private boolean isDuplicateNonExpired(Assertion assertion) {
        return this.idExpirationCache.contains(assertion.getID()) && this.idExpirationCache.getExpiration(assertion.getID()).isAfterNow();
    }
}

