/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import uk.gov.ida.common.shared.security.Certificate;
import uk.gov.ida.saml.metadata.domain.ContactPersonDto;
import uk.gov.ida.saml.metadata.domain.OrganisationDto;

public abstract class MetadataDto {
    protected List<Certificate> encryptionCertificates;
    private DateTime validUntil;
    private String entityId;
    private OrganisationDto organisation;
    private Collection<ContactPersonDto> contactPersons = new ArrayList<ContactPersonDto>();
    private List<Certificate> hubSigningCertificates;

    protected MetadataDto() {
    }

    public MetadataDto(String entityId, DateTime validUntil, OrganisationDto organisation, Collection<ContactPersonDto> contactPersons, List<Certificate> hubSigningCertificates, List<Certificate> encryptionCertificates) {
        this.entityId = entityId;
        this.validUntil = validUntil;
        this.organisation = organisation;
        this.contactPersons = contactPersons;
        this.hubSigningCertificates = hubSigningCertificates;
        this.encryptionCertificates = encryptionCertificates;
    }

    public DateTime getValidUntil() {
        return this.validUntil;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public OrganisationDto getOrganisation() {
        return this.organisation;
    }

    public Collection<ContactPersonDto> getContactPersons() {
        return this.contactPersons;
    }

    public List<Certificate> getSigningCertificates() {
        return this.hubSigningCertificates;
    }

    public Collection<Certificate> getCertificates() {
        ArrayList<Certificate> allCertificates = new ArrayList<Certificate>(this.hubSigningCertificates);
        allCertificates.addAll(this.encryptionCertificates);
        return Collections.unmodifiableList(allCertificates);
    }

    public List<Certificate> getEncryptionCertificates() {
        return this.encryptionCertificates;
    }
}

