/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import com.google.inject.Inject;
import java.util.function.Function;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.IdaSamlMessage;

public abstract class IdaAuthnRequestToAuthnRequestTransformer<TInput extends IdaSamlMessage>
implements Function<TInput, AuthnRequest> {
    private OpenSamlXmlObjectFactory samlObjectFactory;

    @Inject
    protected IdaAuthnRequestToAuthnRequestTransformer(OpenSamlXmlObjectFactory samlObjectFactory) {
        this.samlObjectFactory = samlObjectFactory;
    }

    @Override
    public AuthnRequest apply(TInput originalRequestToIdp) {
        AuthnRequest authnRequest = this.samlObjectFactory.createAuthnRequest();
        authnRequest.setID(originalRequestToIdp.getId());
        authnRequest.setIssueInstant(originalRequestToIdp.getIssueInstant());
        authnRequest.setDestination(originalRequestToIdp.getDestination().toASCIIString());
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Issuer issuer = this.samlObjectFactory.createIssuer(originalRequestToIdp.getIssuer());
        authnRequest.setIssuer(issuer);
        this.supplementAuthnRequestWithDetails(originalRequestToIdp, authnRequest);
        return authnRequest;
    }

    protected abstract void supplementAuthnRequestWithDetails(TInput var1, AuthnRequest var2);

    protected OpenSamlXmlObjectFactory getSamlObjectFactory() {
        return this.samlObjectFactory;
    }
}

