/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.inbound;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.saml.hub.domain.IdpIdaStatus;
import uk.gov.ida.saml.hub.transformers.inbound.SamlStatusToAuthenticationStatusCodeMapper;
import uk.gov.ida.saml.hub.transformers.inbound.SamlStatusToIdpIdaStatusMappingsFactory;

public class SamlStatusToIdaStatusCodeMapper
extends SamlStatusToAuthenticationStatusCodeMapper<IdpIdaStatus.Status> {
    private static final Logger LOG = LoggerFactory.getLogger(SamlStatusToIdaStatusCodeMapper.class);
    private final Map<SamlStatusToIdpIdaStatusMappingsFactory.SamlStatusDefinitions, IdpIdaStatus.Status> statusMappings = SamlStatusToIdpIdaStatusMappingsFactory.getSamlToIdpIdaStatusMappings();

    @Override
    public Optional<IdpIdaStatus.Status> map(Status samlStatus) {
        String statusCodeValue = this.getStatusCodeValue(samlStatus);
        Optional<String> subStatusCodeValue = this.getSubStatusCodeValue(samlStatus);
        List<String> statusDetailValues = this.getStatusDetailValues(samlStatus);
        Optional<IdpIdaStatus.Status> result = this.statusMappings.keySet().stream().filter(k -> k.matches(statusCodeValue, subStatusCodeValue, statusDetailValues)).findFirst().map(this.statusMappings::get);
        if (result.isEmpty()) {
            LOG.info(String.format("Could not map SAML Status: %s, %s, %s", statusCodeValue, subStatusCodeValue, String.join((CharSequence)",", statusDetailValues)));
        }
        return result;
    }

    private Optional<String> getSubStatusCodeValue(Status status) {
        return Optional.ofNullable(status.getStatusCode().getStatusCode()).map(StatusCode::getValue);
    }

    private List<String> getStatusDetailValues(Status samlStatus) {
        Optional<StatusDetail> statusDetail = Optional.ofNullable(samlStatus.getStatusDetail());
        return statusDetail.map((? super T x) -> x.getUnknownXMLObjects().stream().filter(child -> child.getElementQName().getLocalPart().equals("StatusValue")).map((? super T statusDetailVal) -> statusDetailVal.getDOM().getFirstChild().getTextContent()).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }
}

