/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.inbound;

import java.text.MessageFormat;
import java.util.Map;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import uk.gov.ida.saml.core.domain.IdaStatus;

public abstract class IdaStatusUnmarshaller<T extends IdaStatus> {
    private final Map<IdaStatusMapperStatus, T> statusMap;

    public IdaStatusUnmarshaller(Map<IdaStatusMapperStatus, T> statusMap) {
        this.statusMap = statusMap;
    }

    public T fromSaml(Status status) {
        IdaStatusMapperStatus statusMapperStatus = this.getStatusMapperStatus(status);
        if (!this.statusMap.containsKey((Object)statusMapperStatus)) {
            throw new IllegalArgumentException(MessageFormat.format("{0} is not valid in this context", new Object[]{statusMapperStatus}));
        }
        String message = null;
        if (status.getStatusMessage() != null) {
            message = status.getStatusMessage().getMessage();
        }
        return this.transformStatus(statusMapperStatus, message);
    }

    protected T transformStatus(IdaStatusMapperStatus statusMapperStatus, String message) {
        return (T)((IdaStatus)this.statusMap.get((Object)statusMapperStatus));
    }

    private IdaStatusMapperStatus getStatusMapperStatus(Status status) {
        StatusCode topLevelStatusCode = status.getStatusCode();
        switch (topLevelStatusCode.getValue()) {
            case "urn:oasis:names:tc:SAML:2.0:status:Success": {
                return this.getSubStatusForTopLevelSuccessStatus(topLevelStatusCode);
            }
            case "urn:oasis:names:tc:SAML:2.0:status:Responder": {
                return this.getResponderStatus(topLevelStatusCode);
            }
            case "urn:oasis:names:tc:SAML:2.0:status:Requester": {
                return IdaStatusMapperStatus.RequesterError;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Unrecognised top-level status code: {0}", topLevelStatusCode.getValue()));
    }

    private IdaStatusMapperStatus getResponderStatus(StatusCode topLevelStatusCode) {
        StatusCode subStatusCode = topLevelStatusCode.getStatusCode();
        switch (subStatusCode.getValue()) {
            case "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed": {
                return IdaStatusMapperStatus.AuthenticationFailed;
            }
            case "urn:uk:gov:cabinet-office:tc:saml:statuscode:no-match": {
                return IdaStatusMapperStatus.NoMatchingServiceMatchFromMatchingService;
            }
            case "urn:oasis:names:tc:SAML:2.0:status:NoAuthnContext": {
                return IdaStatusMapperStatus.NoAuthenticationContext;
            }
            case "urn:oasis:names:tc:SAML:2.0:status:Requester": {
                return IdaStatusMapperStatus.RequesterErrorFromIdpAsSentByHub;
            }
            case "urn:uk:gov:cabinet-office:tc:saml:statuscode:create-failure": {
                return IdaStatusMapperStatus.CreateFailed;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("{0} - Unrecognised sub-status code.", topLevelStatusCode.getValue()));
    }

    private IdaStatusMapperStatus getSubStatusForTopLevelSuccessStatus(StatusCode topLevelStatusCode) {
        StatusCode subStatusCode = topLevelStatusCode.getStatusCode();
        if (subStatusCode != null) {
            if ("urn:uk:gov:cabinet-office:tc:saml:statuscode:match".equals(subStatusCode.getValue())) {
                return IdaStatusMapperStatus.MatchingServiceMatch;
            }
            if ("urn:uk:gov:cabinet-office:tc:saml:statuscode:no-match".equals(subStatusCode.getValue())) {
                return IdaStatusMapperStatus.NoMatchingServiceMatchFromHub;
            }
            if ("urn:uk:gov:cabinet-office:tc:saml:statuscode:healthy".equals(subStatusCode.getValue())) {
                return IdaStatusMapperStatus.Healthy;
            }
            if ("urn:uk:gov:cabinet-office:tc:saml:statuscode:created".equals(subStatusCode.getValue())) {
                return IdaStatusMapperStatus.Created;
            }
        }
        return IdaStatusMapperStatus.Success;
    }

    protected static enum IdaStatusMapperStatus {
        Success,
        NoAuthenticationContext,
        RequesterError,
        RequesterErrorFromIdpAsSentByHub,
        AuthenticationFailed,
        NoMatchingServiceMatchFromHub,
        NoMatchingServiceMatchFromMatchingService,
        MatchingServiceMatch,
        Healthy,
        Created,
        CreateFailed;

    }
}

