/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.validators;

import java.net.URI;
import java.net.URISyntaxException;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.hub.exception.SamlValidationException;

public class DestinationValidator {
    private final URI expectedUri;

    public DestinationValidator(URI expectedDestinationHost, String expectedEndpoint) {
        this.expectedUri = this.uriWithoutPort(expectedDestinationHost, expectedEndpoint);
    }

    public void validate(String destination) {
        if (destination == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.destinationMissing((URI)this.expectedUri));
        }
        URI destinationURI = URI.create(destination);
        URI destinationURIWithoutPort = this.uriWithoutPort(destinationURI, destinationURI.getPath());
        if (!this.expectedUri.equals(destinationURIWithoutPort)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.destinationEmpty((URI)this.expectedUri, (String)destination));
        }
    }

    private URI uriWithoutPort(URI destinationURI, String endpoint) {
        try {
            return new URI(destinationURI.getScheme(), destinationURI.getHost(), endpoint, null);
        }
        catch (URISyntaxException e) {
            throw new SamlValidationException(SamlTransformationErrorFactory.destinationInvalid((URI)destinationURI, (String)endpoint));
        }
    }
}

