/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.security;

import io.prometheus.client.Counter;
import java.util.List;
import org.opensaml.saml.saml2.core.Assertion;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import uk.gov.ida.saml.security.AssertionDecrypter;
import uk.gov.ida.saml.security.exception.SamlFailedToDecryptException;
import uk.gov.ida.saml.security.validators.ValidatedEncryptedAssertionContainer;
import uk.gov.ida.saml.security.validators.ValidatedResponse;

public class AssertionsDecrypters {
    private final List<AssertionDecrypter> assertionDecrypters;

    public AssertionsDecrypters(List<AssertionDecrypter> decrypters) {
        this.assertionDecrypters = decrypters;
    }

    public List<Assertion> decryptedAssertions(ValidatedResponse validatedResponse, Counter counter, Class responseValidatorClass) {
        for (AssertionDecrypter assertionDecrypter : this.assertionDecrypters) {
            try {
                return assertionDecrypter.decryptAssertions((ValidatedEncryptedAssertionContainer)validatedResponse);
            }
            catch (SamlFailedToDecryptException e) {
                ((Counter.Child)counter.labels(new String[]{validatedResponse.getIssuer().getValue()})).inc();
                this.logFailedToDecryptWarning(validatedResponse, responseValidatorClass, e);
            }
        }
        throw this.samlFailedToDecryptException(validatedResponse, responseValidatorClass);
    }

    private void logFailedToDecryptWarning(ValidatedResponse validatedResponse, Class responseValidatorClass, SamlFailedToDecryptException e) {
        LoggerFactory.getLogger((String)responseValidatorClass.getSimpleName()).warn(String.format("%s failed to decrypt assertions from %s with one of the decrypters", responseValidatorClass.getSimpleName(), validatedResponse.getIssuer().getValue()), (Throwable)e);
    }

    private SamlFailedToDecryptException samlFailedToDecryptException(ValidatedResponse responseValidator, Class klass) {
        return new SamlFailedToDecryptException(String.format("%s could not decrypt assertions from %s with any of the decrypters", klass.getSimpleName(), responseValidator.getIssuer().getValue()), Level.ERROR);
    }
}

