/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata.transformers;

import java.util.List;
import java.util.function.Function;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import uk.gov.ida.common.shared.security.IdGenerator;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.metadata.domain.HubIdentityProviderMetadataDto;
import uk.gov.ida.saml.metadata.domain.SamlEndpointDto;
import uk.gov.ida.saml.metadata.transformers.KeyDescriptorsUnmarshaller;

public class HubIdentityProviderMetadataDtoToEntityDescriptorTransformer
implements Function<HubIdentityProviderMetadataDto, EntityDescriptor> {
    private final OpenSamlXmlObjectFactory openSamlXmlObjectFactory;
    private final KeyDescriptorsUnmarshaller keyDescriptorsUnmarshaller;
    private final IdGenerator idGenerator;

    public HubIdentityProviderMetadataDtoToEntityDescriptorTransformer(OpenSamlXmlObjectFactory openSamlXmlObjectFactory, KeyDescriptorsUnmarshaller keyDescriptorsUnmarshaller, IdGenerator idGenerator) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
        this.keyDescriptorsUnmarshaller = keyDescriptorsUnmarshaller;
        this.idGenerator = idGenerator;
    }

    @Override
    public EntityDescriptor apply(HubIdentityProviderMetadataDto dto) {
        EntityDescriptor entityDescriptor = this.doTransform(dto);
        List keyDescriptors = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getKeyDescriptors();
        keyDescriptors.addAll(this.getKeyDescriptorsUnmarshaller().fromCertificates(dto.getIdpSigningCertificates()));
        keyDescriptors.addAll(this.getKeyDescriptorsUnmarshaller().fromCertificates(dto.getEncryptionCertificates()));
        return entityDescriptor;
    }

    public EntityDescriptor doTransform(HubIdentityProviderMetadataDto dto) {
        EntityDescriptor entityDescriptor = this.openSamlXmlObjectFactory.createEntityDescriptor();
        entityDescriptor.setID(this.idGenerator.getId());
        entityDescriptor.setEntityID(dto.getEntityId());
        entityDescriptor.setValidUntil(dto.getValidUntil());
        IDPSSODescriptor idpSsoDescriptor = this.openSamlXmlObjectFactory.createIDPSSODescriptor();
        idpSsoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        this.transformSingleSignOnServiceEndpoints(idpSsoDescriptor, dto);
        List signingKeyDescriptors = this.keyDescriptorsUnmarshaller.fromCertificates(List.copyOf(dto.getSigningCertificates()));
        idpSsoDescriptor.getKeyDescriptors().addAll(signingKeyDescriptors);
        entityDescriptor.getRoleDescriptors().add(idpSsoDescriptor);
        return entityDescriptor;
    }

    private void transformSingleSignOnServiceEndpoints(IDPSSODescriptor idpSsoDescriptor, HubIdentityProviderMetadataDto dto) {
        for (SamlEndpointDto endpoint : dto.getSingleSignOnEndpoints()) {
            String bindingUri = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
            idpSsoDescriptor.getSingleSignOnServices().add(this.openSamlXmlObjectFactory.createSingleSignOnService(bindingUri, endpoint.getLocation().toASCIIString()));
        }
    }

    protected KeyDescriptorsUnmarshaller getKeyDescriptorsUnmarshaller() {
        return this.keyDescriptorsUnmarshaller;
    }
}

