/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.response.matchingservice;

import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validation.assertion.AssertionValidator;
import uk.gov.ida.saml.hub.exception.SamlValidationException;
import uk.gov.ida.saml.security.validators.ValidatedAssertions;
import uk.gov.ida.saml.security.validators.ValidatedResponse;

public class ResponseAssertionsFromMatchingServiceValidator {
    private AssertionValidator assertionValidator;
    private String hubEntityId;

    public ResponseAssertionsFromMatchingServiceValidator(AssertionValidator assertionValidator, String hubEntityId) {
        this.assertionValidator = assertionValidator;
        this.hubEntityId = hubEntityId;
    }

    public void validate(ValidatedResponse validatedResponse, ValidatedAssertions validatedAssertions) {
        if (!validatedResponse.isSuccess()) {
            return;
        }
        for (Assertion assertion : validatedAssertions.getAssertions()) {
            this.assertionValidator.validate(assertion, validatedResponse.getInResponseTo(), this.hubEntityId);
            if (assertion.getAuthnStatements().isEmpty()) {
                throw new SamlValidationException(SamlTransformationErrorFactory.missingAuthnStatement());
            }
            if (((AuthnStatement)assertion.getAuthnStatements().get(0)).getAuthnContext() != null) continue;
            throw new SamlValidationException(SamlTransformationErrorFactory.authnContextMissingError());
        }
    }
}

