/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.response.matchingservice;

import com.google.common.base.Strings;
import java.util.List;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.xmlsec.signature.Signature;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.hub.exception.SamlValidationException;
import uk.gov.ida.saml.hub.validators.response.common.IssuerValidator;
import uk.gov.ida.saml.hub.validators.response.common.RequestIdValidator;
import uk.gov.ida.saml.security.validators.signature.SamlSignatureUtil;

public class EncryptedResponseFromMatchingServiceValidator {
    public void validate(Response response) {
        IssuerValidator.validate(response);
        RequestIdValidator.validate(response);
        this.validateResponse(response);
    }

    private void validateResponse(Response response) {
        if (Strings.isNullOrEmpty((String)response.getID())) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingId());
        }
        Signature signature = response.getSignature();
        if (signature == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingSignature());
        }
        if (!SamlSignatureUtil.isSignaturePresent((Signature)signature)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.signatureNotSigned());
        }
        this.validateStatusAndSubStatus(response);
        this.validateAssertionPresence(response);
    }

    protected void validateStatusAndSubStatus(Response response) {
        StatusCode statusCode = response.getStatus().getStatusCode();
        String statusCodeValue = statusCode.getValue();
        StatusCode subStatusCode = statusCode.getStatusCode();
        if ("urn:oasis:names:tc:SAML:2.0:status:Requester".equals(statusCodeValue)) {
            return;
        }
        if (subStatusCode == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingSubStatus());
        }
        String subStatusCodeValue = subStatusCode.getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Responder".equals(statusCodeValue)) {
            this.validateSuccessResponse(statusCodeValue, subStatusCodeValue);
        } else {
            this.validateResponderError(subStatusCodeValue);
        }
    }

    private void validateResponderError(String subStatusCodeValue) {
        if (List.of("urn:uk:gov:cabinet-office:tc:saml:statuscode:no-match", "urn:uk:gov:cabinet-office:tc:saml:statuscode:multiple-match", "urn:uk:gov:cabinet-office:tc:saml:statuscode:create-failure").contains(subStatusCodeValue)) {
            return;
        }
        throw new SamlValidationException(SamlTransformationErrorFactory.subStatusMustBeOneOf((String)"Responder", (String)"No Match", (String)"Multi Match", (String)"Create Failure"));
    }

    private void validateSuccessResponse(String statusCodeValue, String subStatusCodeValue) {
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCodeValue)) {
            return;
        }
        if (List.of("urn:uk:gov:cabinet-office:tc:saml:statuscode:match", "urn:uk:gov:cabinet-office:tc:saml:statuscode:no-match", "urn:uk:gov:cabinet-office:tc:saml:statuscode:created").contains(subStatusCodeValue)) {
            return;
        }
        throw new SamlValidationException(SamlTransformationErrorFactory.subStatusMustBeOneOf((String)"Success", (String)"Match", (String)"No Match", (String)"Created"));
    }

    protected void validateAssertionPresence(Response response) {
        if (!response.getAssertions().isEmpty()) {
            throw new SamlValidationException(SamlTransformationErrorFactory.unencryptedAssertion());
        }
        boolean responseWasSuccessful = "urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue());
        boolean responseHasNoAssertions = response.getEncryptedAssertions().isEmpty();
        if (responseWasSuccessful && responseHasNoAssertions) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingSuccessUnEncryptedAssertions());
        }
        if (!responseWasSuccessful && !responseHasNoAssertions) {
            throw new SamlValidationException(SamlTransformationErrorFactory.nonSuccessHasUnEncryptedAssertions());
        }
        if (response.getEncryptedAssertions().size() > 1) {
            throw new SamlValidationException(SamlTransformationErrorFactory.unexpectedNumberOfAssertions((int)1, (int)response.getEncryptedAssertions().size()));
        }
    }
}

