/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.response.idp;

import io.prometheus.client.Counter;
import java.util.List;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import uk.gov.ida.saml.core.security.AssertionsDecrypters;
import uk.gov.ida.saml.core.validators.DestinationValidator;
import uk.gov.ida.saml.hub.validators.response.idp.components.EncryptedResponseFromIdpValidator;
import uk.gov.ida.saml.hub.validators.response.idp.components.ResponseAssertionsFromIdpValidator;
import uk.gov.ida.saml.security.SamlAssertionsSignatureValidator;
import uk.gov.ida.saml.security.validators.ValidatedAssertions;
import uk.gov.ida.saml.security.validators.ValidatedResponse;
import uk.gov.ida.saml.security.validators.signature.SamlResponseSignatureValidator;

public class IdpResponseValidator {
    private final SamlResponseSignatureValidator samlResponseSignatureValidator;
    private final SamlAssertionsSignatureValidator samlAssertionsSignatureValidator;
    private final EncryptedResponseFromIdpValidator<?> responseFromIdpValidator;
    private final DestinationValidator responseDestinationValidator;
    private final ResponseAssertionsFromIdpValidator responseAssertionsFromIdpValidator;
    private final AssertionsDecrypters assertionsDecrypters;
    private ValidatedResponse validatedResponse;
    private ValidatedAssertions validatedAssertions;
    private static final Counter idpDecryptionErrorCounter = (Counter)((Counter.Builder)Counter.build((String)"verify_saml_hub_idp_validator_decryption_error_counter", (String)"IDP Decryption error counter, reports number of errors by IDP").labelNames(new String[]{"entityId"})).register();

    public IdpResponseValidator(SamlResponseSignatureValidator samlResponseSignatureValidator, AssertionsDecrypters assertionsDecrypters, SamlAssertionsSignatureValidator samlAssertionsSignatureValidator, EncryptedResponseFromIdpValidator<?> responseFromIdpValidator, DestinationValidator responseDestinationValidator, ResponseAssertionsFromIdpValidator responseAssertionsFromIdpValidator) {
        this.samlResponseSignatureValidator = samlResponseSignatureValidator;
        this.assertionsDecrypters = assertionsDecrypters;
        this.samlAssertionsSignatureValidator = samlAssertionsSignatureValidator;
        this.responseFromIdpValidator = responseFromIdpValidator;
        this.responseDestinationValidator = responseDestinationValidator;
        this.responseAssertionsFromIdpValidator = responseAssertionsFromIdpValidator;
    }

    public ValidatedResponse getValidatedResponse() {
        return this.validatedResponse;
    }

    public ValidatedAssertions getValidatedAssertions() {
        return this.validatedAssertions;
    }

    public void validate(Response response) {
        this.responseFromIdpValidator.validate(response);
        this.responseDestinationValidator.validate(response.getDestination());
        this.validatedResponse = this.samlResponseSignatureValidator.validate(response, IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        List<Assertion> decryptedAssertions = this.assertionsDecrypters.decryptedAssertions(this.validatedResponse, idpDecryptionErrorCounter, IdpResponseValidator.class);
        this.validatedAssertions = this.samlAssertionsSignatureValidator.validate(decryptedAssertions, IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.responseAssertionsFromIdpValidator.validate(this.validatedResponse, this.validatedAssertions);
    }
}

