/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.IdaStatus;
import uk.gov.ida.saml.core.domain.OutboundResponseFromHub;
import uk.gov.ida.saml.core.domain.TransactionIdaStatus;
import uk.gov.ida.saml.core.transformers.outbound.IdaResponseToSamlResponseTransformer;
import uk.gov.ida.saml.core.transformers.outbound.IdaStatusMarshaller;
import uk.gov.ida.saml.hub.transformers.outbound.EncryptedAssertionUnmarshaller;

public class OutboundResponseFromHubToSamlResponseTransformer
extends IdaResponseToSamlResponseTransformer<OutboundResponseFromHub> {
    private final IdaStatusMarshaller<TransactionIdaStatus> statusMarshaller;
    private final EncryptedAssertionUnmarshaller encryptedAssertionUnmarshaller;

    public OutboundResponseFromHubToSamlResponseTransformer(IdaStatusMarshaller<TransactionIdaStatus> statusMarshaller, OpenSamlXmlObjectFactory openSamlXmlObjectFactory, EncryptedAssertionUnmarshaller encryptedAssertionUnmarshaller) {
        super(openSamlXmlObjectFactory);
        this.statusMarshaller = statusMarshaller;
        this.encryptedAssertionUnmarshaller = encryptedAssertionUnmarshaller;
    }

    protected void transformAssertions(OutboundResponseFromHub originalResponse, Response transformedResponse) {
        originalResponse.getEncryptedAssertions().stream().map(this.encryptedAssertionUnmarshaller::transform).forEach(transformedResponse.getEncryptedAssertions()::add);
    }

    protected Status transformStatus(OutboundResponseFromHub originalResponse) {
        return this.statusMarshaller.toSamlStatus((IdaStatus)originalResponse.getStatus());
    }

    protected void transformDestination(OutboundResponseFromHub originalResponse, Response transformedResponse) {
        transformedResponse.setDestination(originalResponse.getDestination().toASCIIString());
    }
}

