/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.HubAssertion;
import uk.gov.ida.saml.hub.domain.HubAttributeQueryRequest;
import uk.gov.ida.saml.hub.domain.UserAccountCreationAttribute;
import uk.gov.ida.saml.hub.factories.AttributeQueryAttributeFactory;
import uk.gov.ida.saml.hub.transformers.outbound.EncryptedAssertionUnmarshaller;
import uk.gov.ida.saml.hub.transformers.outbound.HubAssertionMarshaller;

public class HubAttributeQueryRequestToSamlAttributeQueryTransformer
implements Function<HubAttributeQueryRequest, AttributeQuery> {
    private final OpenSamlXmlObjectFactory samlObjectFactory;
    private final HubAssertionMarshaller hubAssertionMarshaller;
    private final AttributeQueryAttributeFactory attributeQueryAttributeFactory;
    private final EncryptedAssertionUnmarshaller encryptedAssertionUnmarshaller;

    public HubAttributeQueryRequestToSamlAttributeQueryTransformer(OpenSamlXmlObjectFactory samlObjectFactory, HubAssertionMarshaller hubAssertionMarshaller, AttributeQueryAttributeFactory attributeQueryAttributeFactory, EncryptedAssertionUnmarshaller encryptedAssertionUnmarshaller) {
        this.samlObjectFactory = samlObjectFactory;
        this.hubAssertionMarshaller = hubAssertionMarshaller;
        this.attributeQueryAttributeFactory = attributeQueryAttributeFactory;
        this.encryptedAssertionUnmarshaller = encryptedAssertionUnmarshaller;
    }

    @Override
    public AttributeQuery apply(HubAttributeQueryRequest originalQuery) {
        AttributeQuery transformedQuery = this.samlObjectFactory.createAttributeQuery();
        Issuer issuer = this.samlObjectFactory.createIssuer(originalQuery.getIssuer());
        transformedQuery.setID(originalQuery.getId());
        transformedQuery.setIssuer(issuer);
        transformedQuery.setIssueInstant(DateTime.now());
        if (originalQuery.getUserAccountCreationAttributes().isPresent()) {
            transformedQuery.getAttributes().addAll(this.createAttributeList(originalQuery.getUserAccountCreationAttributes().get()));
        }
        Subject subject = this.samlObjectFactory.createSubject();
        NameID nameId = this.samlObjectFactory.createNameId(originalQuery.getPersistentId().getNameId());
        nameId.setSPNameQualifier(originalQuery.getAuthnRequestIssuerEntityId());
        nameId.setNameQualifier(originalQuery.getAssertionConsumerServiceUrl().toASCIIString());
        subject.setNameID(nameId);
        SubjectConfirmation subjectConfirmation = this.samlObjectFactory.createSubjectConfirmation();
        SubjectConfirmationData subjectConfirmationData = this.samlObjectFactory.createSubjectConfirmationData();
        Stream.of(originalQuery.getEncryptedMatchingDatasetAssertion(), originalQuery.getEncryptedAuthnAssertion()).map(this.encryptedAssertionUnmarshaller::transform).forEach(subjectConfirmationData.getUnknownXMLObjects(EncryptedAssertion.DEFAULT_ELEMENT_NAME)::add);
        Optional<HubAssertion> cycle3DatasetAssertion = originalQuery.getCycle3AttributeAssertion();
        if (cycle3DatasetAssertion.isPresent()) {
            Assertion transformedCycle3DatasetAssertion = this.hubAssertionMarshaller.toSaml(cycle3DatasetAssertion.get());
            subjectConfirmationData.getUnknownXMLObjects(Assertion.DEFAULT_ELEMENT_NAME).add(transformedCycle3DatasetAssertion);
        }
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        transformedQuery.setSubject(subject);
        return transformedQuery;
    }

    private List<Attribute> createAttributeList(List<UserAccountCreationAttribute> userAccountCreationAttributes) {
        return userAccountCreationAttributes.stream().map(this.attributeQueryAttributeFactory::createAttribute).collect(Collectors.toList());
    }
}

