/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import java.util.Map;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Issuer;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.Cycle3Dataset;
import uk.gov.ida.saml.core.domain.HubAssertion;
import uk.gov.ida.saml.core.domain.OutboundAssertion;
import uk.gov.ida.saml.core.transformers.outbound.OutboundAssertionToSubjectTransformer;
import uk.gov.ida.saml.hub.factories.AttributeFactory;

public class HubAssertionMarshaller {
    private final OpenSamlXmlObjectFactory openSamlXmlObjectFactory;
    private final AttributeFactory attributeFactory;
    private final OutboundAssertionToSubjectTransformer outboundAssertionToSubjectTransformer;

    public HubAssertionMarshaller(OpenSamlXmlObjectFactory openSamlXmlObjectFactory, AttributeFactory attributeFactory, OutboundAssertionToSubjectTransformer outboundAssertionToSubjectTransformer) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
        this.attributeFactory = attributeFactory;
        this.outboundAssertionToSubjectTransformer = outboundAssertionToSubjectTransformer;
    }

    public Assertion toSaml(HubAssertion hubAssertion) {
        Assertion transformedAssertion = this.openSamlXmlObjectFactory.createAssertion();
        transformedAssertion.setIssueInstant(hubAssertion.getIssueInstant());
        Issuer transformedIssuer = this.openSamlXmlObjectFactory.createIssuer(hubAssertion.getIssuerId());
        transformedAssertion.setIssuer(transformedIssuer);
        transformedAssertion.setID(hubAssertion.getId());
        if (hubAssertion.getCycle3Data().isPresent()) {
            Cycle3Dataset cycle3Data = (Cycle3Dataset)hubAssertion.getCycle3Data().get();
            transformedAssertion.getAttributeStatements().add(this.transform(cycle3Data));
        }
        transformedAssertion.setSubject(this.outboundAssertionToSubjectTransformer.transform((OutboundAssertion)hubAssertion));
        return transformedAssertion;
    }

    private AttributeStatement transform(Cycle3Dataset cycle3Data) {
        AttributeStatement attributeStatement = this.openSamlXmlObjectFactory.createAttributeStatement();
        for (Map.Entry entry : cycle3Data.getAttributes().entrySet()) {
            Attribute data = this.attributeFactory.createCycle3DataAttribute((String)entry.getKey(), (String)entry.getValue());
            attributeStatement.getAttributes().add(data);
        }
        return attributeStatement;
    }
}

