/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.validators.assertion;

import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validators.assertion.DuplicateAssertionValidator;
import uk.gov.ida.saml.hub.exception.SamlValidationException;

public class AuthnStatementAssertionValidator {
    private final DuplicateAssertionValidator duplicateAssertionValidator;

    public AuthnStatementAssertionValidator(DuplicateAssertionValidator duplicateAssertionValidator) {
        this.duplicateAssertionValidator = duplicateAssertionValidator;
    }

    public void validate(Assertion assertion) {
        this.validateAuthnStatement((AuthnStatement)assertion.getAuthnStatements().get(0));
        this.duplicateAssertionValidator.validateAuthnStatementAssertion(assertion);
    }

    private void validateAuthnStatement(AuthnStatement authnStatement) {
        if (authnStatement.getAuthnContext() == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.authnContextMissingError());
        }
        if (authnStatement.getAuthnContext().getAuthnContextClassRef() == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.authnContextClassRefMissing());
        }
        if (authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef() == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.authnContextClassRefValueMissing());
        }
        if (authnStatement.getAuthnInstant() == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.authnInstantMissing());
        }
    }
}

