/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.test.builders;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.xmlsec.signature.Signature;
import uk.gov.ida.saml.core.domain.AuthnContext;
import uk.gov.ida.saml.hub.domain.AuthnRequestFromTransaction;
import uk.gov.ida.saml.hub.domain.IdaAuthnRequestFromHub;

public class IdaAuthnRequestBuilder {
    private String id = UUID.randomUUID().toString();
    private String issuer = "issuer_id";
    private DateTime issueInstant = DateTime.now();
    private List<AuthnContext> levelsOfAssurance = Collections.singletonList(AuthnContext.LEVEL_1);
    private Optional<Boolean> forceAuthentication = Optional.empty();
    private Optional<Integer> assertionConsumerServiceIndex = Optional.empty();
    private Optional<Signature> signature = Optional.empty();
    private URI destination = URI.create("http://thehub");
    private Optional<DateTime> sessionExpiry = Optional.empty();
    private Optional<URI> assertionConsumerServiceUrl = Optional.empty();
    private AuthnContextComparisonTypeEnumeration comparisonType = AuthnContextComparisonTypeEnumeration.EXACT;

    public static IdaAuthnRequestBuilder anIdaAuthnRequest() {
        return new IdaAuthnRequestBuilder();
    }

    public IdaAuthnRequestFromHub buildFromHub() {
        return new IdaAuthnRequestFromHub(this.id, this.issuer, this.issueInstant, this.levelsOfAssurance, this.forceAuthentication, this.sessionExpiry.orElse(DateTime.now().plusHours(20)), URI.create("/location"), this.comparisonType);
    }

    public AuthnRequestFromTransaction buildFromTransaction() {
        if (this.sessionExpiry.isPresent()) {
            throw new IllegalStateException("sessionExpiry can only be set on an authn request from hub");
        }
        return new AuthnRequestFromTransaction(this.id, this.issuer, this.issueInstant, this.forceAuthentication, this.assertionConsumerServiceUrl, this.assertionConsumerServiceIndex, this.signature, this.destination);
    }

    public IdaAuthnRequestBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public IdaAuthnRequestBuilder withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public IdaAuthnRequestBuilder withIssueInstant(DateTime issueInstant) {
        this.issueInstant = issueInstant;
        return this;
    }

    public IdaAuthnRequestBuilder withLevelsOfAssurance(List<AuthnContext> levelsOfAssurance) {
        this.levelsOfAssurance = levelsOfAssurance;
        return this;
    }

    public IdaAuthnRequestBuilder withForceAuthentication(Optional<Boolean> forceAuthentication) {
        this.forceAuthentication = forceAuthentication;
        return this;
    }

    public IdaAuthnRequestBuilder withAssertionConsumerServiceIndex(int index) {
        this.assertionConsumerServiceIndex = Optional.ofNullable(index);
        return this;
    }

    public IdaAuthnRequestBuilder withAssertionConsumerServiceUrl(URI url) {
        this.assertionConsumerServiceUrl = Optional.ofNullable(url);
        return this;
    }

    public IdaAuthnRequestBuilder withoutAssertionConsumerServiceIndex() {
        this.assertionConsumerServiceIndex = Optional.empty();
        return this;
    }

    public IdaAuthnRequestBuilder withDestination(URI destination) {
        this.destination = destination;
        return this;
    }

    public IdaAuthnRequestBuilder withSessionExpiryTimestamp(DateTime sessionExpiryTimestamp) {
        this.sessionExpiry = Optional.ofNullable(sessionExpiryTimestamp);
        return this;
    }

    public IdaAuthnRequestBuilder withSignature(Signature signature) {
        this.signature = Optional.ofNullable(signature);
        return this;
    }

    public IdaAuthnRequestBuilder withComparisonType(AuthnContextComparisonTypeEnumeration comparisonType) {
        this.comparisonType = comparisonType;
        return this;
    }
}

