/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.msa.test.outbound.transformers;

import com.google.inject.Inject;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.MatchingServiceAuthnStatement;

public class MatchingServiceAuthnStatementToAuthnStatementTransformer {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory;

    @Inject
    public MatchingServiceAuthnStatementToAuthnStatementTransformer(OpenSamlXmlObjectFactory openSamlXmlObjectFactory) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
    }

    public AuthnStatement transform(MatchingServiceAuthnStatement idaAuthnStatement) {
        AuthnStatement authnStatement = this.openSamlXmlObjectFactory.createAuthnStatement();
        AuthnContext authnContext = this.openSamlXmlObjectFactory.createAuthnContext();
        authnContext.setAuthnContextClassRef(this.openSamlXmlObjectFactory.createAuthnContextClassReference(idaAuthnStatement.getAuthnContext().getUri()));
        authnStatement.setAuthnContext(authnContext);
        authnStatement.setAuthnInstant(DateTime.now());
        return authnStatement;
    }
}

