/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.msa.test.outbound.transformers;

import com.google.inject.Inject;
import java.util.List;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.impl.AttributeStatementBuilder;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.MatchingServiceAuthnStatement;
import uk.gov.ida.saml.core.domain.OutboundAssertion;
import uk.gov.ida.saml.core.transformers.outbound.OutboundAssertionToSubjectTransformer;
import uk.gov.ida.saml.msa.test.domain.MatchingServiceAssertion;
import uk.gov.ida.saml.msa.test.outbound.transformers.MatchingServiceAuthnStatementToAuthnStatementTransformer;

public class MatchingServiceAssertionToAssertionTransformer {
    private final OpenSamlXmlObjectFactory openSamlXmlObjectFactory;
    private final MatchingServiceAuthnStatementToAuthnStatementTransformer matchingServiceAuthnStatementToAuthnStatementTransformer;
    private final OutboundAssertionToSubjectTransformer outboundAssertionToSubjectTransformer;
    private XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();

    @Inject
    public MatchingServiceAssertionToAssertionTransformer(OpenSamlXmlObjectFactory openSamlXmlObjectFactory, MatchingServiceAuthnStatementToAuthnStatementTransformer matchingServiceAuthnStatementToAuthnStatementTransformer, OutboundAssertionToSubjectTransformer outboundAssertionToSubjectTransformer) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
        this.matchingServiceAuthnStatementToAuthnStatementTransformer = matchingServiceAuthnStatementToAuthnStatementTransformer;
        this.outboundAssertionToSubjectTransformer = outboundAssertionToSubjectTransformer;
    }

    public Assertion transform(MatchingServiceAssertion originalAssertion) {
        Assertion transformedAssertion = this.openSamlXmlObjectFactory.createAssertion();
        transformedAssertion.setIssueInstant(originalAssertion.getIssueInstant());
        Issuer transformedIssuer = this.openSamlXmlObjectFactory.createIssuer(originalAssertion.getIssuerId());
        transformedAssertion.setIssuer(transformedIssuer);
        transformedAssertion.setID(originalAssertion.getId());
        Subject subject = this.outboundAssertionToSubjectTransformer.transform((OutboundAssertion)originalAssertion);
        transformedAssertion.setSubject(subject);
        MatchingServiceAuthnStatement authnStatement = originalAssertion.getAuthnStatement();
        transformedAssertion.getAuthnStatements().add(this.matchingServiceAuthnStatementToAuthnStatementTransformer.transform(authnStatement));
        Conditions conditions = this.openSamlXmlObjectFactory.createConditions();
        AudienceRestriction audienceRestriction = this.openSamlXmlObjectFactory.createAudienceRestriction(originalAssertion.getAudience());
        conditions.getAudienceRestrictions().add(audienceRestriction);
        transformedAssertion.setConditions(conditions);
        List<Attribute> userAttributesForAccountCreation = originalAssertion.getUserAttributesForAccountCreation();
        if (!userAttributesForAccountCreation.isEmpty()) {
            this.addAttributes(transformedAssertion, userAttributesForAccountCreation);
        }
        return transformedAssertion;
    }

    private void addAttributes(Assertion transformedAssertion, List<Attribute> userAttributesForAccountCreation) {
        AttributeStatementBuilder attributeStatementBuilder = (AttributeStatementBuilder)this.builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement attributeStatement = attributeStatementBuilder.buildObject();
        attributeStatement.getAttributes().addAll(userAttributesForAccountCreation);
        transformedAssertion.getAttributeStatements().add(attributeStatement);
    }
}

