/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test;

import java.net.URI;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnRequest;
import uk.gov.ida.saml.core.test.TestCredentialFactory;
import uk.gov.ida.saml.core.test.builders.AuthnRequestBuilder;
import uk.gov.ida.saml.core.test.builders.IssuerBuilder;
import uk.gov.ida.saml.serializers.XmlObjectToBase64EncodedStringTransformer;

public class AuthnRequestFactory {
    private final Function<AuthnRequest, String> authnRequestToStringTransformer;

    public AuthnRequestFactory(Function<AuthnRequest, String> authnRequestToStringTransformer) {
        this.authnRequestToStringTransformer = authnRequestToStringTransformer;
    }

    public String anAuthnRequest(String id, String issuer, Optional<Boolean> forceAuthentication, Optional<URI> assertionConsumerServiceUrl, Optional<Integer> assertionConsumerServiceIndex, String publicCert, String privateKey, String ssoRequestEndpoint, Optional<DateTime> issueInstant) {
        AuthnRequest authnRequest = this.getAuthnRequest(id, issuer, forceAuthentication, assertionConsumerServiceUrl, assertionConsumerServiceIndex, publicCert, privateKey, ssoRequestEndpoint, issueInstant);
        return this.authnRequestToStringTransformer.apply(authnRequest);
    }

    private AuthnRequest getAuthnRequest(String id, String issuer, Optional<Boolean> forceAuthentication, Optional<URI> assertionConsumerServiceUrl, Optional<Integer> assertionConsumerServiceIndex, String publicCert, String privateKey, String ssoRequestEndpoint, Optional<DateTime> issueInstant) {
        AuthnRequestBuilder authnRequestBuilder = AuthnRequestBuilder.anAuthnRequest().withId(id).withIssuer(IssuerBuilder.anIssuer().withIssuerId(issuer).build()).withDestination("http://localhost" + ssoRequestEndpoint).withSigningCredential(new TestCredentialFactory(publicCert, privateKey).getSigningCredential());
        forceAuthentication.ifPresent(arg_0 -> ((AuthnRequestBuilder)authnRequestBuilder).withForceAuthn(arg_0));
        assertionConsumerServiceIndex.ifPresent(arg_0 -> ((AuthnRequestBuilder)authnRequestBuilder).withAssertionConsumerServiceIndex(arg_0));
        assertionConsumerServiceUrl.ifPresent(uri -> authnRequestBuilder.withAssertionConsumerServiceUrl(uri.toString()));
        issueInstant.ifPresent(arg_0 -> ((AuthnRequestBuilder)authnRequestBuilder).withIssueInstant(arg_0));
        return authnRequestBuilder.build();
    }

    public String anInvalidAuthnRequest(String id, String issuer, Optional<Boolean> forceAuthentication, Optional<URI> assertionConsumerServiceUrl, Optional<Integer> assertionConsumerServiceIndex, String publicCert, String privateKey, String ssoRequestEndpoint, Optional<DateTime> issueInstant) {
        AuthnRequest authnRequest = this.getAuthnRequest(StringUtils.rightPad((String)id, (int)1200, (String)"x"), issuer, forceAuthentication, assertionConsumerServiceUrl, assertionConsumerServiceIndex, publicCert, privateKey, ssoRequestEndpoint, issueInstant);
        authnRequest.setSignature(null);
        XmlObjectToBase64EncodedStringTransformer transformer = new XmlObjectToBase64EncodedStringTransformer();
        return transformer.apply((XMLObject)authnRequest);
    }
}

