/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.msa.test.transformers;

import com.google.inject.Inject;
import java.util.function.Function;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.w3c.dom.Element;
import uk.gov.ida.saml.core.transformers.outbound.decorators.ResponseAssertionSigner;
import uk.gov.ida.saml.core.transformers.outbound.decorators.ResponseSignatureCreator;
import uk.gov.ida.saml.core.transformers.outbound.decorators.SamlResponseAssertionEncrypter;
import uk.gov.ida.saml.core.transformers.outbound.decorators.SamlSignatureSigner;
import uk.gov.ida.saml.serializers.XmlObjectToElementTransformer;

public class ResponseToElementTransformer
implements Function<Response, Element> {
    private final XmlObjectToElementTransformer<Response> xmlObjectToElementTransformer;
    private final SamlSignatureSigner<Response> samlSignatureSigner;
    private final SamlResponseAssertionEncrypter samlResponseAssertionEncrypter;
    private final ResponseAssertionSigner responseAssertionSigner;
    private final ResponseSignatureCreator responseSignatureCreator;

    @Inject
    public ResponseToElementTransformer(XmlObjectToElementTransformer<Response> xmlObjectToElementTransformer, SamlSignatureSigner<Response> samlSignatureSigner, SamlResponseAssertionEncrypter samlResponseAssertionEncrypter, ResponseAssertionSigner responseAssertionSigner, ResponseSignatureCreator responseSignatureCreator) {
        this.xmlObjectToElementTransformer = xmlObjectToElementTransformer;
        this.samlSignatureSigner = samlSignatureSigner;
        this.samlResponseAssertionEncrypter = samlResponseAssertionEncrypter;
        this.responseAssertionSigner = responseAssertionSigner;
        this.responseSignatureCreator = responseSignatureCreator;
    }

    @Override
    public Element apply(Response response) {
        Response responseWithSignature = this.responseSignatureCreator.addUnsignedSignatureTo(response);
        Response responseWithSignedAssertions = this.responseAssertionSigner.signAssertions(responseWithSignature);
        Response responseWithEncryptedAssertions = (Response)this.samlResponseAssertionEncrypter.encryptAssertions((Object)responseWithSignedAssertions);
        Response signedResponse = (Response)this.samlSignatureSigner.sign((SignableXMLObject)responseWithEncryptedAssertions);
        return this.xmlObjectToElementTransformer.apply((XMLObject)signedResponse);
    }
}

