/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders.metadata;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import uk.gov.ida.common.shared.security.Certificate;
import uk.gov.ida.saml.core.test.builders.CertificateBuilder;
import uk.gov.ida.saml.core.test.builders.ContactPersonDtoBuilder;
import uk.gov.ida.saml.core.test.builders.OrganisationDtoBuilder;
import uk.gov.ida.saml.metadata.domain.ContactPersonDto;
import uk.gov.ida.saml.metadata.domain.HubIdentityProviderMetadataDto;
import uk.gov.ida.saml.metadata.domain.OrganisationDto;
import uk.gov.ida.saml.metadata.domain.SamlEndpointDto;

public class IdentityProviderMetadataDtoBuilder {
    private List<SamlEndpointDto> singleSignOnServiceEndpoints = new ArrayList<SamlEndpointDto>();
    private String entityId = "https://signin.service.gov.uk";
    private OrganisationDto organisation = OrganisationDtoBuilder.anOrganisationDto().build();
    private List<ContactPersonDto> contactPersons = new ArrayList<ContactPersonDto>();
    private List<Certificate> signingCertificates = null;
    private DateTime validUntil = DateTime.now().plus((ReadableDuration)Duration.standardDays((long)365L));
    private List<Certificate> idpSigningCertificates = new ArrayList<Certificate>();
    private Certificate encryptionCertificate = null;
    private boolean useDefaultSingleSignOnServiceEndpoints = true;
    private boolean useDefaultContactPerson = true;

    public static IdentityProviderMetadataDtoBuilder anIdentityProviderMetadataDto() {
        return new IdentityProviderMetadataDtoBuilder();
    }

    public HubIdentityProviderMetadataDto build() {
        this.populateListsWithDefaults();
        return new HubIdentityProviderMetadataDto(this.singleSignOnServiceEndpoints, this.entityId, this.organisation, this.contactPersons, this.idpSigningCertificates, this.validUntil, this.signingCertificates, this.encryptionCertificate);
    }

    private void populateListsWithDefaults() {
        if (this.useDefaultSingleSignOnServiceEndpoints) {
            this.singleSignOnServiceEndpoints.add(SamlEndpointDto.createPostBinding((URI)URI.create("https://hub.ida.gov.uk/SAML2/SSO/POST")));
        }
        if (this.useDefaultContactPerson) {
            this.contactPersons.add(ContactPersonDtoBuilder.aContactPersonDto().build());
        }
        if (this.signingCertificates == null && this.entityId != null) {
            this.withSigningCertificate(CertificateBuilder.aCertificate().withKeyUse(Certificate.KeyUse.Signing).withIssuerId(this.entityId).build());
        }
        if (this.idpSigningCertificates.isEmpty()) {
            this.idpSigningCertificates.add(CertificateBuilder.aCertificate().build());
        }
        if (this.encryptionCertificate == null && this.entityId != null) {
            this.encryptionCertificate = CertificateBuilder.aCertificate().withKeyUse(Certificate.KeyUse.Encryption).withIssuerId(this.entityId).build();
        }
    }

    public IdentityProviderMetadataDtoBuilder addSingleSignOnServiceEndpoint(SamlEndpointDto samlEndpoint) {
        this.singleSignOnServiceEndpoints.add(samlEndpoint);
        this.useDefaultSingleSignOnServiceEndpoints = false;
        return this;
    }

    public IdentityProviderMetadataDtoBuilder withEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public IdentityProviderMetadataDtoBuilder addContactPerson(ContactPersonDto contactPerson) {
        this.contactPersons.add(contactPerson);
        this.useDefaultContactPerson = false;
        return this;
    }

    public IdentityProviderMetadataDtoBuilder withSigningCertificate(Certificate certificate) {
        this.signingCertificates = List.of(certificate);
        return this;
    }

    public IdentityProviderMetadataDtoBuilder withSigningCertificates(List<Certificate> signingCertificates) {
        this.signingCertificates = signingCertificates;
        return this;
    }

    public IdentityProviderMetadataDtoBuilder withValidUntil(DateTime validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public IdentityProviderMetadataDtoBuilder addIdpSigningCertificate(Certificate certificate) {
        this.idpSigningCertificates.add(certificate);
        return this;
    }

    public IdentityProviderMetadataDtoBuilder withHubEncryptionCertificate(Certificate certificate) {
        this.encryptionCertificate = certificate;
        return this;
    }
}

