/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test.builders;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import uk.gov.ida.saml.metadata.domain.ContactPersonDto;

public class ContactPersonDtoBuilder {
    private static final String DEFAULT_TELEPHONE_NUMBER = "0113 496 0000";
    private static final URI DEFAULT_EMAIL_ADDRESS = URI.create("mailto:default@example.com");
    private String companyName = "default-company-name";
    private String givenName = "default-given-name";
    private String surName = "default-sur-name";
    private List<String> telephoneNumbers = new ArrayList<String>();
    private List<URI> emailAddresses = new ArrayList<URI>();
    private boolean addDefaultTelephoneNumber = true;
    private boolean addDefaultEmailAddress = true;

    public static ContactPersonDtoBuilder aContactPersonDto() {
        return new ContactPersonDtoBuilder();
    }

    public ContactPersonDto build() {
        if (this.addDefaultTelephoneNumber) {
            this.telephoneNumbers.add(DEFAULT_TELEPHONE_NUMBER);
        }
        if (this.addDefaultEmailAddress) {
            this.emailAddresses.add(DEFAULT_EMAIL_ADDRESS);
        }
        return new ContactPersonDto(this.companyName, this.givenName, this.surName, this.telephoneNumbers, this.emailAddresses);
    }

    public ContactPersonDtoBuilder withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public ContactPersonDtoBuilder withGivenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    public ContactPersonDtoBuilder withSurName(String surName) {
        this.surName = surName;
        return this;
    }

    public ContactPersonDtoBuilder addTelephoneNumber(String number) {
        this.telephoneNumbers.add(number);
        this.addDefaultTelephoneNumber = false;
        return this;
    }

    public ContactPersonDtoBuilder withoutDefaultTelephoneNumber() {
        this.addDefaultTelephoneNumber = false;
        return this;
    }

    public ContactPersonDtoBuilder addEmailAddress(URI emailAddress) {
        this.emailAddresses.add(emailAddress);
        this.addDefaultEmailAddress = false;
        return this;
    }

    public ContactPersonDtoBuilder withoutDefaultEmailAddress() {
        this.addDefaultEmailAddress = false;
        return this;
    }
}

