/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.metrics.bundle;

import com.codahale.metrics.Metric;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.hotspot.DefaultExports;
import javax.servlet.Servlet;
import uk.gov.ida.metrics.config.PrometheusConfiguration;

public class PrometheusBundle
implements ConfiguredBundle<PrometheusConfiguration> {
    public static final String PROMETHEUS_METRICS_RESOURCE = "/prometheus/metrics";

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(PrometheusConfiguration configuration, Environment environment) {
        if (configuration.isPrometheusEnabled()) {
            DefaultExports.initialize();
            CollectorRegistry.defaultRegistry.register((Collector)new DropwizardExports(environment.metrics(), this::isNotJvmMetric));
            environment.admin().addServlet("metrics", (Servlet)new MetricsServlet()).addMapping(new String[]{PROMETHEUS_METRICS_RESOURCE});
        }
    }

    private boolean isNotJvmMetric(String name, Metric metric) {
        return !name.startsWith("jvm.");
    }
}

