/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.dropwizard.logstash;

import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import io.dropwizard.logging.SyslogAppenderFactory;
import java.text.MessageFormat;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class SyslogEventFormatter {
    private final SyslogAppenderFactory.Facility facility;
    private final String hostname;
    private final String tag;
    private final Layout<ILoggingEvent> layout;

    public SyslogEventFormatter(SyslogAppenderFactory.Facility facility, String hostname, String tag, Layout<ILoggingEvent> layout) {
        this.facility = facility;
        this.hostname = hostname;
        this.tag = tag;
        this.layout = layout;
        this.layout.start();
    }

    public String format(ILoggingEvent event) {
        int priority = this.getPriority(event);
        String timestamp = ISODateTimeFormat.dateTime().print((ReadableInstant)DateTime.now().withZone(DateTimeZone.UTC));
        String encodedEvent = this.encodeEvent(event);
        return MessageFormat.format("<{0}>1 {1} {2} {3} - - - {4}", priority, timestamp, this.hostname, this.tag, encodedEvent);
    }

    private int getPriority(ILoggingEvent event) {
        String facilityString = this.facility.toString().toLowerCase(Locale.ENGLISH);
        int facilityCode = SyslogAppender.facilityStringToint((String)facilityString);
        return facilityCode + this.getSeverity(event);
    }

    private int getSeverity(ILoggingEvent event) {
        return 5;
    }

    private String encodeEvent(ILoggingEvent event) {
        return this.layout.doLayout((Object)event);
    }
}

