/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.dropwizard.logstash;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.net.SyslogOutputStream;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.logging.SyslogAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.logstash.logback.layout.LogstashLayout;
import uk.gov.ida.dropwizard.logstash.SyslogAppender;
import uk.gov.ida.dropwizard.logstash.SyslogEventFormatter;

@JsonTypeName(value="logstash-syslog")
public class LogstashSyslogAppenderFactory
extends AbstractAppenderFactory<ILoggingEvent> {
    @NotNull
    @JsonProperty
    private String host = "localhost";
    @Min(value=1L)
    @Max(value=65535L)
    @JsonProperty
    private int port = 514;
    @NotNull
    @JsonProperty
    private SyslogAppenderFactory.Facility facility = SyslogAppenderFactory.Facility.LOCAL1;
    @NotNull
    @JsonProperty
    public String tag;

    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, LayoutFactory<ILoggingEvent> layout, LevelFilterFactory<ILoggingEvent> levelFilterFactory, AsyncAppenderFactory<ILoggingEvent> asyncAppenderFactory) {
        String hostname = this.getLocalHostname();
        LogstashLayout logstashLayout = this.createLogstashLayout((Context)context);
        logstashLayout.start();
        SyslogEventFormatter eventFormatter = new SyslogEventFormatter(this.facility, hostname, this.tag, (Layout<ILoggingEvent>)logstashLayout);
        SyslogOutputStream outputStream = this.createSyslogOutputStream();
        SyslogAppender appender = this.createAppender(eventFormatter, outputStream, context);
        appender.start();
        return this.wrapAsync((Appender)appender, asyncAppenderFactory);
    }

    private SyslogAppender createAppender(SyslogEventFormatter eventFormatter, SyslogOutputStream outputStream, LoggerContext context) {
        SyslogAppender appender = new SyslogAppender(eventFormatter, outputStream);
        appender.setName("logstash-syslog-appender");
        appender.setContext((Context)context);
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(this.threshold.toString());
        filter.start();
        appender.addFilter((Filter)filter);
        return appender;
    }

    private LogstashLayout createLogstashLayout(Context context) {
        LogstashLayout logstashLayout = new LogstashLayout();
        logstashLayout.setContext(context);
        logstashLayout.setIncludeCallerData(false);
        return logstashLayout;
    }

    private SyslogOutputStream createSyslogOutputStream() {
        try {
            return new SyslogOutputStream(this.host, this.port);
        }
        catch (SocketException | UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLocalHostname() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

