/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.dropwizard.logstash;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.FileAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import net.logstash.logback.encoder.LogstashEncoder;

@JsonTypeName(value="logstash-file")
public class LogstashFileAppenderFactory
extends FileAppenderFactory<ILoggingEvent> {
    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, LayoutFactory<ILoggingEvent> layout, LevelFilterFactory<ILoggingEvent> levelFilterFactory, AsyncAppenderFactory<ILoggingEvent> asyncAppenderFactory) {
        LogstashEncoder encoder = new LogstashEncoder();
        encoder.setContext((Context)context);
        encoder.start();
        FileAppender appender = this.buildAppender(context);
        appender.setName("logstash-file-appender");
        appender.setAppend(true);
        appender.setContext((Context)context);
        appender.setEncoder((Encoder)encoder);
        appender.setFile(this.getCurrentLogFilename());
        appender.setPrudent(false);
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(this.threshold.toString());
        filter.start();
        appender.addFilter((Filter)filter);
        appender.start();
        return this.wrapAsync((Appender)appender, asyncAppenderFactory);
    }
}

