/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.dropwizard.logstash;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.spi.ContextAware;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonGenerator;
import io.dropwizard.logging.ConsoleAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import java.io.IOException;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.composite.AbstractNestedJsonProvider;
import net.logstash.logback.composite.CompositeJsonFormatter;
import net.logstash.logback.composite.JsonProvider;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.composite.LogstashVersionJsonProvider;
import net.logstash.logback.composite.accessevent.AccessEventCompositeJsonFormatter;
import net.logstash.logback.composite.accessevent.AccessEventFormattedTimestampJsonProvider;
import net.logstash.logback.composite.accessevent.AccessMessageJsonProvider;
import net.logstash.logback.composite.accessevent.MethodJsonProvider;
import net.logstash.logback.composite.accessevent.RemoteUserJsonProvider;
import net.logstash.logback.composite.accessevent.StatusCodeJsonProvider;
import net.logstash.logback.encoder.AccessEventCompositeJsonEncoder;
import uk.gov.ida.dropwizard.logstash.typed.BytesField;
import uk.gov.ida.dropwizard.logstash.typed.MillisecondsField;

@JsonTypeName(value="access-logstash-console")
public class AccessLogstashConsoleAppenderFactory
extends ConsoleAppenderFactory<IAccessEvent> {
    public Appender<IAccessEvent> build(LoggerContext context, String applicationName, LayoutFactory<IAccessEvent> layout, LevelFilterFactory<IAccessEvent> levelFilterFactory, AsyncAppenderFactory<IAccessEvent> asyncAppenderFactory) {
        AccessEventCompositeJsonEncoder encoder = new AccessEventCompositeJsonEncoder(){

            protected CompositeJsonFormatter<IAccessEvent> createFormatter() {
                return new CustomFormatter((ContextAware)this);
            }
        };
        encoder.setContext((Context)context);
        encoder.start();
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName("access-logstash-console-appender");
        appender.setContext((Context)context);
        appender.setTarget(this.getTarget().get());
        appender.setEncoder((Encoder)encoder);
        appender.start();
        return this.wrapAsync((Appender)appender, asyncAppenderFactory);
    }

    public static class HostJsonProvider
    extends AbstractJsonProvider<IAccessEvent> {
        public void writeTo(JsonGenerator generator, IAccessEvent event) throws IOException {
            generator.writeStringField("host", event.getRequestHeader("Host"));
        }
    }

    public static class UserAgentJsonProvider
    extends AbstractJsonProvider<IAccessEvent> {
        public void writeTo(JsonGenerator generator, IAccessEvent event) throws IOException {
            generator.writeStringField("agent", event.getRequestHeader("User-Agent"));
        }
    }

    public static class RefererJsonProvider
    extends AbstractJsonProvider<IAccessEvent> {
        public void writeTo(JsonGenerator generator, IAccessEvent event) throws IOException {
            generator.writeStringField("referrer", event.getRequestHeader("Referer"));
        }
    }

    public static class RemoteIpJsonProvider
    extends AbstractJsonProvider<IAccessEvent> {
        public void writeTo(JsonGenerator generator, IAccessEvent event) throws IOException {
            generator.writeStringField("remote_ip", event.getRemoteAddr());
        }
    }

    public static class UrlJsonProvider
    extends AbstractJsonProvider<IAccessEvent> {
        public void writeTo(JsonGenerator generator, IAccessEvent event) throws IOException {
            String firstLineWithoutMethod = this.firstLineOfRequest(event).replaceFirst("^[A-Z]* ", "");
            String requestedUrl = firstLineWithoutMethod.replaceFirst(" HTTP/.*$", "");
            generator.writeStringField("url", requestedUrl);
        }

        private String firstLineOfRequest(IAccessEvent event) {
            return event.getRequestURL();
        }
    }

    public static class HttpVersionJsonProvider
    extends AbstractJsonProvider<IAccessEvent> {
        public void writeTo(JsonGenerator generator, IAccessEvent event) throws IOException {
            generator.writeStringField("http_version", event.getProtocol().replace("HTTP/", ""));
        }
    }

    public static class BodySentJsonProvider
    extends AbstractJsonProvider<IAccessEvent> {
        public void writeTo(JsonGenerator generator, IAccessEvent event) throws IOException {
            generator.writeObjectField("body_sent", (Object)new BytesField(event.getContentLength()));
        }
    }

    public static class ElapsedTimeMsJsonProvider
    extends AbstractJsonProvider<IAccessEvent> {
        public void writeTo(JsonGenerator generator, IAccessEvent event) throws IOException {
            generator.writeObjectField("elapsed_time", (Object)new MillisecondsField(event.getElapsedTime()));
        }
    }

    private class CustomFormatter
    extends AccessEventCompositeJsonFormatter {
        public CustomFormatter(ContextAware declaredOrigin) {
            super(declaredOrigin);
            JsonProviders topLevel = this.getProviders();
            topLevel.addProvider((JsonProvider)new AccessEventFormattedTimestampJsonProvider());
            topLevel.addProvider((JsonProvider)new LogstashVersionJsonProvider());
            topLevel.addProvider((JsonProvider)new AccessMessageJsonProvider(){
                {
                    this.setFieldName("message");
                }
            });
            topLevel.addProvider(this.accessProvider());
        }

        private JsonProvider<IAccessEvent> accessProvider() {
            AbstractNestedJsonProvider<IAccessEvent> access = new AbstractNestedJsonProvider<IAccessEvent>(){};
            access.setFieldName("access");
            JsonProviders accessProviders = access.getProviders();
            accessProviders.addProvider((JsonProvider)new MethodJsonProvider(){
                {
                    this.setFieldName("method");
                }
            });
            accessProviders.addProvider((JsonProvider)new HttpVersionJsonProvider());
            accessProviders.addProvider((JsonProvider)new RefererJsonProvider());
            accessProviders.addProvider((JsonProvider)new UserAgentJsonProvider());
            accessProviders.addProvider((JsonProvider)new HostJsonProvider());
            accessProviders.addProvider((JsonProvider)new StatusCodeJsonProvider(){
                {
                    this.setFieldName("response_code");
                }
            });
            accessProviders.addProvider((JsonProvider)new UrlJsonProvider());
            accessProviders.addProvider((JsonProvider)new RemoteIpJsonProvider());
            accessProviders.addProvider((JsonProvider)new RemoteUserJsonProvider(){
                {
                    this.setFieldName("user_name");
                }
            });
            accessProviders.addProvider((JsonProvider)new BodySentJsonProvider());
            accessProviders.addProvider((JsonProvider)new ElapsedTimeMsJsonProvider());
            return access;
        }
    }
}

