/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.shared.utils.logging;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import uk.gov.ida.shared.utils.logging.LogFormatter;

public class LevelLogger<T> {
    private final Logger log;

    private LevelLogger(Class<T> clazz) {
        this.log = LoggerFactory.getLogger(clazz);
    }

    static <T> LevelLogger<T> getLevelLogger(Class<T> clazz) {
        return new LevelLogger<T>(clazz);
    }

    public void log(Level level, Exception exception, UUID errorId) {
        if (level == Level.ERROR) {
            this.log.error(LogFormatter.formatLog(errorId, exception.getMessage()), (Throwable)exception);
        }
        if (level == Level.WARN) {
            this.log.warn(LogFormatter.formatLog(errorId, exception.getMessage()), (Throwable)exception);
        }
        if (level == Level.INFO) {
            this.log.info(LogFormatter.formatLog(errorId, exception.getMessage()), (Throwable)exception);
        }
        if (level == Level.DEBUG) {
            this.log.debug(LogFormatter.formatLog(errorId, exception.getMessage()), (Throwable)exception);
        }
    }

    public void log(Level level, Exception exception) {
        this.log(level, exception, UUID.randomUUID());
    }
}

