/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.shared.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class XmlUtils {
    private static final String FEATURE_DISALLOW_DOCTYPE_DECLARATIONS = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final Logger LOG = LoggerFactory.getLogger(XmlUtils.class);

    public static String writeToString(Node node) {
        try {
            StringWriter docWriter = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(node), new StreamResult(docWriter));
            return docWriter.toString();
        }
        catch (TransformerException ex) {
            LOG.error("Unable to convert Element to String", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public static Element convertToElement(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        return XmlUtils.newDocumentBuilder().parse(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8))).getDocumentElement();
    }

    public static Document convertToDocument(String xmlString) {
        try {
            return XmlUtils.newDocumentBuilder().parse(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature(FEATURE_DISALLOW_DOCTYPE_DECLARATIONS, true);
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }
}

