/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.shared.utils.string;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public abstract class StringEncoding {
    public static final String ENCODING = "UTF-8";

    public static String toBase64Encoded(String unencodedString) {
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])StringUtils.getBytesUtf8((String)unencodedString)));
    }

    public static String toBase64Encoded(byte[] bytes) {
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])bytes));
    }

    public static String fromBase64Encoded(String encodedString) {
        return StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)encodedString));
    }

    public static byte[] fromBase64ToByteArrayEncoded(String encodedString) {
        return Base64.decodeBase64((String)encodedString);
    }

    public static String urlEncode(String input) {
        String encodedValue;
        try {
            encodedValue = URLEncoder.encode(input, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return encodedValue;
    }

    public static String urlDecode(String input) {
        String decodedValue;
        try {
            decodedValue = URLDecoder.decode(input, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return decodedValue;
    }

    public static String nullSafeUrlDecode(String urlEncodedValue) {
        String urlDecodedValue = null;
        if (urlEncodedValue != null) {
            urlDecodedValue = StringEncoding.urlDecode(urlEncodedValue);
        }
        return urlDecodedValue;
    }
}

