/*
 * Decompiled with CFR 0.152.
 */
package httpstub;

import com.fasterxml.jackson.core.JsonProcessingException;
import httpstub.AbstractHttpStub;
import httpstub.ExpectedRequest;
import httpstub.HttpStub;
import httpstub.RecordedRequest;
import httpstub.RegisteredResponse;
import httpstub.RequestAndResponse;
import httpstub.builders.ExpectedRequestBuilder;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class HttpStubExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final AbstractHttpStub httpStub;

    public HttpStubExtension(AbstractHttpStub httpStub) {
        this.httpStub = httpStub;
    }

    public HttpStubExtension() {
        this(new HttpStub());
    }

    public void beforeAll(ExtensionContext context) {
        this.httpStub.start();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.httpStub.stop();
    }

    public int getPort() {
        return this.httpStub.getHttpPort();
    }

    public URI uri(String path) {
        return this.baseUri().path(path).build(new Object[0]);
    }

    public UriBuilder baseUri() {
        return UriBuilder.fromUri((String)"http://localhost").port(this.getPort());
    }

    public void register(String path, int responseStatus) {
        RequestAndResponse requestAndResponse = ExpectedRequestBuilder.expectRequest().withPath(path).andWillRespondWith().withStatus(responseStatus).build();
        this.register(requestAndResponse);
    }

    public void register(String path, int responseStatus, String contentType, String responseBody) throws JsonProcessingException {
        RequestAndResponse requestAndResponse = ExpectedRequestBuilder.expectRequest().withPath(path).andWillRespondWith().withStatus(responseStatus).withContentType(contentType).withBody(responseBody).build();
        this.register(requestAndResponse);
    }

    public void register(String path, int status, Object responseEntity) throws JsonProcessingException {
        RequestAndResponse requestAndResponse = ExpectedRequestBuilder.expectRequest().withPath(path).andWillRespondWith().withStatus(status).withBody(responseEntity).build();
        this.register(requestAndResponse);
    }

    public void register(String path, RegisteredResponse registeredResponse) {
        this.register(ExpectedRequestBuilder.expectRequest().withPath(path).build(), registeredResponse);
    }

    public void register(ExpectedRequest expectedRequest, RegisteredResponse registeredResponse) {
        RequestAndResponse requestAndResponse = new RequestAndResponse(expectedRequest, registeredResponse);
        this.register(requestAndResponse);
    }

    public void register(RequestAndResponse requestAndResponse) {
        this.httpStub.register(requestAndResponse);
    }

    public void start() {
        this.httpStub.start();
    }

    public void reset() {
        this.httpStub.reset();
    }

    public int getCountOfRequestsTo(String path) {
        return this.httpStub.getCountOfRequestsTo(path);
    }

    public int getCountOfRequests() {
        return this.httpStub.getCountOfRequests();
    }

    public RecordedRequest getLastRequest() {
        return this.httpStub.getLastRequest();
    }

    public List<RecordedRequest> getRecordedRequest() {
        return this.httpStub.getRecordedRequests();
    }
}

